/*
 * Decompiled with CFR 0.152.
 */
package com.github.qacore.testingtoolbox.configuration;

import com.github.qacore.testingtoolbox.configuration.AdditionalProperties;
import java.util.HashMap;
import java.util.Map;

public class JUnitConfiguration
extends AdditionalProperties<Object, Object> {
    public static final String PARALLEL_TEST_THREADS_PER_CORE = "toolbox.junit.parallelTestThreadsPerCore";
    private double parallelTestThreadsPerCore = Double.parseDouble(System.getProperty("toolbox.junit.parallelTestThreadsPerCore", "1"));

    public JUnitConfiguration(Map<Object, Object> additionalProperties) {
        super(additionalProperties);
    }

    public JUnitConfiguration() {
        this((Map<Object, Object>)new HashMap<Object, Object>());
    }

    public double getParallelTestThreadsPerCore() {
        return this.parallelTestThreadsPerCore;
    }

    public void setParallelTestThreadsPerCore(double parallelTestThreadsPerCore) {
        this.parallelTestThreadsPerCore = parallelTestThreadsPerCore;
    }

    public int getTotalTestThreads() {
        double parallelTestThreadsPerCore = this.getParallelTestThreadsPerCore() * (double)Runtime.getRuntime().availableProcessors();
        if (parallelTestThreadsPerCore - (double)((int)parallelTestThreadsPerCore) >= 0.5) {
            parallelTestThreadsPerCore += 1.0;
        }
        if (parallelTestThreadsPerCore < 1.0) {
            return 1;
        }
        return (int)parallelTestThreadsPerCore;
    }

    @Override
    public String toString() {
        return "JUnitConfiguration(parallelTestThreadsPerCore=" + this.getParallelTestThreadsPerCore() + ")";
    }
}

