/*
 * Decompiled with CFR 0.152.
 */
package com.github.qacore.testingtoolbox.configuration.selenium;

import com.github.qacore.testingtoolbox.configuration.AdditionalProperties;
import com.github.qacore.testingtoolbox.selenium.parallel.WebDriverManager;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;

public abstract class AbstractWebDriverConfiguration<I, T extends WebDriver>
extends AdditionalProperties<Object, Object> {
    private Capabilities defaultCapabilities;

    public AbstractWebDriverConfiguration(Map<Object, Object> additionalProperties) {
        super(additionalProperties);
    }

    public AbstractWebDriverConfiguration() {
        this((Map<Object, Object>)new HashMap<Object, Object>());
    }

    public T start(boolean managed, Capabilities other) {
        T webDriver = this.start(other);
        if (managed) {
            WebDriverManager.setDriver(webDriver);
        }
        return webDriver;
    }

    public abstract T start(Capabilities var1);

    public T start(boolean managed) {
        return this.start(managed, null);
    }

    public T start() {
        return this.start(false, null);
    }

    public Capabilities getDefaultCapabilities() {
        return this.defaultCapabilities;
    }

    public I setDefaultCapabilities(Capabilities defaultCapabilities) {
        this.defaultCapabilities = defaultCapabilities;
        return this.itself();
    }

    public String getPath() {
        return System.getProperty(this.getPathProperty());
    }

    public I setPath(String path) {
        if (path == null) {
            System.clearProperty(this.getPathProperty());
        } else {
            System.setProperty(this.getPathProperty(), path);
        }
        return this.itself();
    }

    public abstract String getPathProperty();

    protected Capabilities mergeCapabilities(Capabilities other, Capabilities defaultIfNull) {
        Capabilities capabilities = this.getDefaultCapabilities();
        if (capabilities == null) {
            if (other != null) {
                return other;
            }
        } else {
            if (other == null) {
                return capabilities;
            }
            return capabilities.merge(other);
        }
        return defaultIfNull;
    }

    protected Capabilities mergeCapabilities(Capabilities other) {
        return this.mergeCapabilities(other, null);
    }

    protected I itself() {
        return (I)this;
    }
}

