/*
 * Decompiled with CFR 0.152.
 */
package com.github.qacore.testingtoolbox.junit.runners.schedulers;

import com.github.qacore.testingtoolbox.JavaTestingToolbox;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.junit.runners.model.RunnerScheduler;

public class ParallelScheduler
implements RunnerScheduler {
    private static ExecutorService EXECUTOR_SERVICE;
    private List<Callable<Void>> childStatements = new ArrayList<Callable<Void>>();

    public static final synchronized ExecutorService getExecutorService() {
        if (EXECUTOR_SERVICE == null) {
            EXECUTOR_SERVICE = Executors.newFixedThreadPool(JavaTestingToolbox.getConfiguration().junit().getTotalTestThreads(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = Executors.defaultThreadFactory().newThread(r);
                    thread.setName("JUnit-" + thread.getName());
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return EXECUTOR_SERVICE;
    }

    public void schedule(final Runnable childStatement) {
        this.getChildStatements().add(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                childStatement.run();
                return null;
            }
        });
    }

    public void finished() {
        try {
            ParallelScheduler.getExecutorService().invokeAll(this.getChildStatements());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public List<Callable<Void>> getChildStatements() {
        return this.childStatements;
    }

    public void setChildStatements(List<Callable<Void>> childStatements) {
        this.childStatements = childStatements;
    }
}

