/*
 * Decompiled with CFR 0.152.
 */
package com.github.randomcodeorg.ppplugin;

import com.github.randomcodeorg.ppplugin.PProcessor;
import com.github.randomcodeorg.ppplugin.data.BuildLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PContext {
    private final Set<Class<?>> classes;
    private final Set<Class<? extends PProcessor>> declaredProcessors;
    private final Map<Class<?>, File> classFileMap;
    private final BuildLog log;
    private final File classRoot;
    private final Map<Class<?>, InputStream> modifications = new HashMap();
    private final List<String> classPaths;

    protected PContext(BuildLog logger, File classRoot, List<String> classPaths, Set<Class<?>> classes, Map<Class<?>, File> classFileMap, Set<Class<? extends PProcessor>> declaredProcessors) {
        this.classes = Collections.unmodifiableSet(classes);
        this.classFileMap = classFileMap;
        this.log = logger;
        this.classRoot = classRoot;
        this.classPaths = Collections.unmodifiableList(classPaths);
        this.declaredProcessors = Collections.unmodifiableSet(declaredProcessors);
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Class<? extends PProcessor>> getDeclaredProcessors() {
        return this.declaredProcessors;
    }

    public File getFile(Class<?> c) {
        if (this.classFileMap.containsKey(c)) {
            return this.classFileMap.get(c);
        }
        return null;
    }

    public File getClassRoot() {
        return this.classRoot;
    }

    public BuildLog getLog() {
        return this.log;
    }

    public OutputStream modify(Class<?> cl) {
        return this.doModify(cl, this.modifications);
    }

    protected abstract OutputStream doModify(Class<?> var1, Map<Class<?>, InputStream> var2);

    public List<String> getClassPaths() {
        return this.classPaths;
    }

    protected void complete() throws IOException {
        for (Class<?> cl : this.modifications.keySet()) {
            InputStream in = this.modifications.get(cl);
            File f = this.getFile(cl);
            FileOutputStream fos = new FileOutputStream(f, false);
            this.doCopy(in, fos);
            fos.flush();
            fos.close();
            in.close();
        }
    }

    protected abstract void doCopy(InputStream var1, OutputStream var2) throws IOException;
}

