/*
 * Decompiled with CFR 0.152.
 */
package com.buck.common.codec;

import com.buck.common.codec.Codec;
import com.buck.common.codec.CodecDecoder;
import com.buck.common.codec.CodecEncoder;
import com.buck.common.codec.MalformedInputException;
import com.buck.common.codec.StandardCodecs;
import com.buck.commons.i18n.ResourceBundle;
import java.io.ByteArrayOutputStream;

public class PercentEncoded
extends Codec {
    private static final boolean pooled = false;
    private static final byte ESCAPE_CHAR = 37;
    private static final int BASELENGTH = 128;
    private static final byte[] decoderAlphabet;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] encoderAlphabet;
    private static final int UNRESERVED_LENGTH = 256;
    private static final byte[] isUnreserved;

    public PercentEncoded() {
        super("pct-encoded", StandardCodecs.aliases_PercentEncoded);
    }

    @Override
    public CodecDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CodecEncoder newEncoder() {
        return new Encoder(this);
    }

    static {
        int i;
        decoderAlphabet = new byte[128];
        encoderAlphabet = new byte[16];
        isUnreserved = new byte[256];
        for (i = 0; i < 128; ++i) {
            PercentEncoded.decoderAlphabet[i] = -1;
        }
        for (i = 48; i <= 57; ++i) {
            PercentEncoded.decoderAlphabet[i] = (byte)(i - 48);
        }
        for (i = 65; i <= 70; ++i) {
            PercentEncoded.decoderAlphabet[i] = (byte)(i - 65 + 10);
        }
        for (i = 97; i <= 102; ++i) {
            PercentEncoded.decoderAlphabet[i] = (byte)(i - 65 + 10);
        }
        for (i = 0; i < 16; ++i) {
            PercentEncoded.encoderAlphabet[i] = -1;
        }
        for (i = 0; i <= 9; ++i) {
            PercentEncoded.encoderAlphabet[i] = (byte)(48 + i);
        }
        for (i = 10; i <= 15; ++i) {
            PercentEncoded.encoderAlphabet[i] = (byte)(65 + i - 10);
        }
        for (i = 0; i < 256; ++i) {
            PercentEncoded.isUnreserved[i] = 0;
        }
        for (i = 97; i <= 122; ++i) {
            PercentEncoded.isUnreserved[i] = 1;
        }
        for (i = 65; i <= 90; ++i) {
            PercentEncoded.isUnreserved[i] = 1;
        }
        for (i = 48; i <= 57; ++i) {
            PercentEncoded.isUnreserved[i] = 1;
        }
        PercentEncoded.isUnreserved[45] = 1;
        PercentEncoded.isUnreserved[46] = 1;
        PercentEncoded.isUnreserved[95] = 1;
        PercentEncoded.isUnreserved[126] = 1;
    }

    private static class Encoder
    extends CodecEncoder {
        public Encoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] encode(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            int size = bytes.length;
            for (int n : bytes) {
                int b = n;
                if (b < 0) {
                    b = 256 + b;
                }
                if (isUnreserved[b] != 0) continue;
                size += 2;
            }
            byte[] buffer = new byte[size];
            int i = 0;
            int j = 0;
            while (i < bytes.length) {
                int n = bytes[i];
                if (n < 0) {
                    n = 256 + n;
                }
                if (isUnreserved[n] != 0) {
                    buffer[j] = (byte)n;
                } else {
                    buffer[j++] = 37;
                    buffer[j++] = encoderAlphabet[n >> 4 & 0xF];
                    buffer[j] = encoderAlphabet[n & 0xF];
                }
                ++i;
                ++j;
            }
            return buffer;
        }
    }

    private static class Decoder
    extends CodecDecoder {
        public Decoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] decode(byte[] encoded) {
            if (encoded == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(encoded.length);
            for (int i = 0; i < encoded.length; ++i) {
                byte b = encoded[i];
                if (b == 37) {
                    try {
                        byte u = decoderAlphabet[encoded[++i]];
                        byte l = decoderAlphabet[encoded[++i]];
                        if (u == -1 || l == -1) {
                            Object[] arguments = new Object[]{"percent-encoded"};
                            String message = ResourceBundle.formatResourceBundleMessage(PercentEncoded.class, (String)"CODEC_DECODER_MALFORMED_INPUT", (Object[])arguments);
                            throw new MalformedInputException(message);
                        }
                        buffer.write((char)((u << 4) + l));
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Object[] arguments = new Object[]{(byte)37};
                        String message = ResourceBundle.formatResourceBundleMessage(PercentEncoded.class, (String)"CODEC_DECODER_INCOMPLETE_ESCAPE", (Object[])arguments);
                        throw new MalformedInputException(message, e);
                    }
                }
                buffer.write(b);
            }
            return buffer.toByteArray();
        }
    }
}

