/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.viewmodels;

import io.reactivesprint.Preconditions;
import io.reactivesprint.rx.Command;
import io.reactivesprint.rx.ICommand;
import io.reactivesprint.rx.IMutableProperty;
import io.reactivesprint.rx.IProperty;
import io.reactivesprint.rx.MutableProperty;
import io.reactivesprint.rx.Pair;
import io.reactivesprint.rx.Property;
import io.reactivesprint.viewmodels.IFetchedArrayViewModel;
import io.reactivesprint.viewmodels.ViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;

public class FetchedArrayViewModel<E extends ViewModel>
extends ViewModel
implements IFetchedArrayViewModel<E, Integer, Void, Collection<E>>,
RandomAccess {
    private MutableProperty<List<E>> viewModels = new MutableProperty(Collections.emptyList());
    private final IProperty<Integer> count;
    private final IProperty<Boolean> empty;
    private final IMutableProperty<CharSequence> localizedEmptyMessage = new MutableProperty<Object>(null);
    private final MutableProperty<Boolean> refreshing = new MutableProperty<Boolean>(false);
    private final MutableProperty<Boolean> fetchingNextPage = new MutableProperty<Boolean>(false);
    private final MutableProperty<Boolean> hasNextPage = new MutableProperty<Boolean>(true);
    private Integer nextPage;
    private final Func1<Integer, Observable<Pair<Integer, Collection<E>>>> fetchFunc;
    private final ICommand<Void, Collection<E>> refreshCommand;
    private final ICommand<Void, Collection<E>> fetchCommand;
    private final ICommand<Void, Collection<E>> fetchIfNeededCommand;

    public FetchedArrayViewModel(Func1<Integer, Observable<Pair<Integer, Collection<E>>>> fetchFunc) {
        Preconditions.checkNotNull(fetchFunc, "fetchFunc");
        this.fetchFunc = fetchFunc;
        this.count = new Property<Integer>(0, this.viewModels.getObservable().map(new Func1<List<E>, Integer>(){

            public Integer call(List<E> elements) {
                return elements.size();
            }
        }));
        this.empty = new Property<Boolean>(this.count.getValue() <= 0, this.count.getObservable().map((Func1)new Func1<Integer, Boolean>(){

            public Boolean call(Integer integer) {
                return integer <= 0;
            }
        }));
        this.fetchCommand = this.createFetchCommand();
        this.refreshCommand = this.createRefreshCommand();
        this.fetchIfNeededCommand = this.createFetchIfNeededCommand();
    }

    @Override
    public Iterator<E> iterator() {
        return this.viewModels.getValue().iterator();
    }

    @Override
    public IProperty<Integer> getCount() {
        return this.count;
    }

    @Override
    public IProperty<Boolean> isEmpty() {
        return this.empty;
    }

    public IMutableProperty<CharSequence> getLocalizedEmptyMessage() {
        return this.localizedEmptyMessage;
    }

    @Override
    public List<E> getViewModels() {
        return this.viewModels.getValue();
    }

    @Override
    public int indexOf(E element) {
        Preconditions.checkNotNull(element, "element");
        return this.viewModels.getValue().indexOf(element);
    }

    @Override
    public E getViewModel(int index) {
        return (E)((ViewModel)this.viewModels.getValue().get(index));
    }

    @Override
    public IProperty<Boolean> isRefreshing() {
        return new Property<Boolean>(this.refreshing);
    }

    @Override
    public Integer getNextPage() {
        return this.nextPage;
    }

    @Override
    public IProperty<Boolean> isFetchingNextPage() {
        return new Property<Boolean>(this.fetchingNextPage);
    }

    @Override
    public IProperty<Boolean> hasNextPage() {
        return new Property<Boolean>(this.hasNextPage);
    }

    @Override
    public ICommand<Void, Collection<E>> getRefreshCommand() {
        return this.refreshCommand;
    }

    @Override
    public ICommand<Void, Collection<E>> getFetchCommand() {
        return this.fetchCommand;
    }

    @Override
    public ICommand<Void, Collection<E>> getFetchIfNeededCommand() {
        return this.fetchIfNeededCommand;
    }

    protected ICommand<Void, Collection<E>> createRefreshCommand() {
        Command<Void, Collection<E>> command = new Command<Void, Collection<E>>(this.isEnabled(), new Func1<Void, Observable<Collection<E>>>(){

            public Observable<Collection<E>> call(Void aVoid) {
                FetchedArrayViewModel.this.refreshing.setValue(true);
                return FetchedArrayViewModel.this.fetch(null);
            }
        });
        this.bindCommand(command);
        return command;
    }

    protected ICommand<Void, Collection<E>> createFetchCommand() {
        Command<Void, Collection<E>> command = new Command<Void, Collection<E>>(this.isEnabled(), new Func1<Void, Observable<Collection<E>>>(){

            public Observable<Collection<E>> call(Void aVoid) {
                if (FetchedArrayViewModel.this.nextPage != null) {
                    FetchedArrayViewModel.this.fetchingNextPage.setValue(true);
                } else {
                    FetchedArrayViewModel.this.refreshing.setValue(true);
                }
                return FetchedArrayViewModel.this.fetch(FetchedArrayViewModel.this.nextPage);
            }
        });
        this.bindCommand(command);
        return command;
    }

    protected ICommand<Void, Collection<E>> createFetchIfNeededCommand() {
        return new Command<Void, Collection<E>>(this.isEnabled(), new Func1<Void, Observable<Collection<E>>>(){

            public Observable<Collection<E>> call(Void input) {
                if (FetchedArrayViewModel.this.getNextPage() != null && FetchedArrayViewModel.this.hasNextPage().getValue().booleanValue()) {
                    return FetchedArrayViewModel.this.getFetchCommand().apply(input);
                }
                return Observable.empty();
            }
        });
    }

    private Observable<Collection<E>> fetch(Integer nextPage) {
        return ((Observable)this.fetchFunc.call((Object)nextPage)).doOnNext(new Action1<Pair<Integer, Collection<E>>>(){

            public void call(Pair<Integer, Collection<E>> objects) {
                ArrayList newViewModels = new ArrayList();
                if (!((Boolean)FetchedArrayViewModel.this.refreshing.getValue()).booleanValue()) {
                    newViewModels.addAll((Collection)FetchedArrayViewModel.this.viewModels.getValue());
                }
                newViewModels.addAll(objects.getValue1());
                FetchedArrayViewModel.this.viewModels.setValue(newViewModels);
                FetchedArrayViewModel.this.hasNextPage.setValue(!objects.getValue1().isEmpty());
                FetchedArrayViewModel.this.nextPage = objects.getValue0();
            }
        }).doAfterTerminate(new Action0(){

            public void call() {
                FetchedArrayViewModel.this.refreshing.setValue(false);
                FetchedArrayViewModel.this.fetchingNextPage.setValue(false);
            }
        }).map(new Func1<Pair<Integer, Collection<E>>, Collection<E>>(){

            public Collection<E> call(Pair<Integer, Collection<E>> objects) {
                return objects.getValue1();
            }
        });
    }
}

