/*
 * Decompiled with CFR 0.152.
 */
package com.wellebee.sanskrit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Sanscript {
    private Options defaults = new HashOptions().set("skip_sgml", false).set("syncope", false);
    private Schemes schemes = new Schemes();
    private Map<String, Boolean> romanSchemes = new HashMap<String, Boolean>();
    private Alternates allAlternates = new Alternates();
    private Cache cache = new Cache();

    public Sanscript() {
        this.initializeSchemes();
        this.initializeAlternates();
        this.initializeSpecialSchemes();
    }

    public Schemes getSchemes() {
        return this.schemes;
    }

    private void initializeSchemes() {
        HashScheme hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"\u0985", "\u0986", "\u0987", "\u0988", "\u0989", "\u098a", "\u098b", "\u09e0", "\u098c", "\u09e1", "", "\u098f", "\u0990", "", "\u0993", "\u0994"});
        hashScheme.put("vowel_marks", new String[]{"\u09be", "\u09bf", "\u09c0", "\u09c1", "\u09c2", "\u09c3", "\u09c4", "\u09e2", "\u09e3", "", "\u09c7", "\u09c8", "", "\u09cb", "\u09cc"});
        hashScheme.put("other_marks", new String[]{"\u0982", "\u0983", "\u0981"});
        hashScheme.put("virama", new String[]{"\u09cd"});
        hashScheme.put("consonants", new String[]{"\u0995", "\u0996", "\u0997", "\u0998", "\u0999", "\u099a", "\u099b", "\u099c", "\u099d", "\u099e", "\u099f", "\u09a0", "\u09a1", "\u09a2", "\u09a3", "\u09a4", "\u09a5", "\u09a6", "\u09a7", "\u09a8", "\u09aa", "\u09ab", "\u09ac", "\u09ad", "\u09ae", "\u09af", "\u09b0", "\u09b2", "\u09ac", "\u09b6", "\u09b7", "\u09b8", "\u09b9", "\u0933", "\u0995\u09cd\u09b7", "\u099c\u09cd\u099e"});
        hashScheme.put("symbols", new String[]{"\u09e6", "\u09e7", "\u09e8", "\u09e9", "\u09ea", "\u09eb", "\u09ec", "\u09ed", "\u09ee", "\u09ef", "\u0950", "\u09bd", "\u0964", "\u0965"});
        hashScheme.put("other", new String[]{"", "", "", "", "\u09a1", "\u09a2", "", "\u09af", ""});
        this.schemes.put("bengali", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"\u0905", "\u0906", "\u0907", "\u0908", "\u0909", "\u090a", "\u090b", "\u0960", "\u090c", "\u0961", "\u090e", "\u090f", "\u0910", "\u0912", "\u0913", "\u0914"});
        hashScheme.put("vowel_marks", new String[]{"\u093e", "\u093f", "\u0940", "\u0941", "\u0942", "\u0943", "\u0944", "\u0962", "\u0963", "\u0946", "\u0947", "\u0948", "\u094a", "\u094b", "\u094c"});
        hashScheme.put("other_marks", new String[]{"\u0902", "\u0903", "\u0901"});
        hashScheme.put("virama", new String[]{"\u094d"});
        hashScheme.put("consonants", new String[]{"\u0915", "\u0916", "\u0917", "\u0918", "\u0919", "\u091a", "\u091b", "\u091c", "\u091d", "\u091e", "\u091f", "\u0920", "\u0921", "\u0922", "\u0923", "\u0924", "\u0925", "\u0926", "\u0927", "\u0928", "\u092a", "\u092b", "\u092c", "\u092d", "\u092e", "\u092f", "\u0930", "\u0932", "\u0935", "\u0936", "\u0937", "\u0938", "\u0939", "\u0933", "\u0915\u094d\u0937", "\u091c\u094d\u091e"});
        hashScheme.put("symbols", new String[]{"\u0966", "\u0967", "\u0968", "\u0969", "\u096a", "\u096b", "\u096c", "\u096d", "\u096e", "\u096f", "\u0950", "\u093d", "\u0964", "\u0965"});
        hashScheme.put("zwj", new String[]{"\u200d"});
        hashScheme.put("skip", new String[]{""});
        hashScheme.put("accent", new String[]{"\u0951", "\u0952"});
        hashScheme.put("combo_accent", new String[]{"\u0903\u0951", "\u0903\u0952", "\u0902\u0951", "\u0902\u0952"});
        hashScheme.put("candra", new String[]{"\u0945"});
        hashScheme.put("other", new String[]{"\u0915\u093c", "\u0916\u093c", "\u0917\u093c", "\u091c\u093c", "\u0921\u093c", "\u0922\u093c", "\u092b\u093c", "\u092f\u093c", "\u0931"});
        this.schemes.put("devanagari", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"\u0a85", "\u0a86", "\u0a87", "\u0a88", "\u0a89", "\u0a8a", "\u0a8b", "\u0ae0", "\u0a8c", "\u0ae1", "", "\u0a8f", "\u0a90", "", "\u0a93", "\u0a94"});
        hashScheme.put("vowel_marks", new String[]{"\u0abe", "\u0abf", "\u0ac0", "\u0ac1", "\u0ac2", "\u0ac3", "\u0ac4", "\u0ae2", "\u0ae3", "", "\u0ac7", "\u0ac8", "", "\u0acb", "\u0acc"});
        hashScheme.put("other_marks", new String[]{"\u0a82", "\u0a83", "\u0a81"});
        hashScheme.put("virama", new String[]{"\u0acd"});
        hashScheme.put("consonants", new String[]{"\u0a95", "\u0a96", "\u0a97", "\u0a98", "\u0a99", "\u0a9a", "\u0a9b", "\u0a9c", "\u0a9d", "\u0a9e", "\u0a9f", "\u0aa0", "\u0aa1", "\u0aa2", "\u0aa3", "\u0aa4", "\u0aa5", "\u0aa6", "\u0aa7", "\u0aa8", "\u0aaa", "\u0aab", "\u0aac", "\u0aad", "\u0aae", "\u0aaf", "\u0ab0", "\u0ab2", "\u0ab5", "\u0ab6", "\u0ab7", "\u0ab8", "\u0ab9", "\u0ab3", "\u0a95\u0acd\u0ab7", "\u0a9c\u0acd\u0a9e"});
        hashScheme.put("symbols", new String[]{"\u0ae6", "\u0ae7", "\u0ae8", "\u0ae9", "\u0aea", "\u0aeb", "\u0aec", "\u0aed", "\u0aee", "\u0aef", "\u0ad0", "\u0abd", "\u0ae4", "\u0ae5"});
        hashScheme.put("candra", new String[]{"\u0ac5"});
        this.schemes.put("gujarati", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"\u0a05", "\u0a06", "\u0a07", "\u0a08", "\u0a09", "\u0a0a", "", "", "", "", "", "\u0a0f", "\u0a10", "", "\u0a13", "\u0a14"});
        hashScheme.put("vowel_marks", new String[]{"\u0a3e", "\u0a3f", "\u0a40", "\u0a41", "\u0a42", "", "", "", "", "", "\u0a47", "\u0a48", "", "\u0a4b", "\u0a4c"});
        hashScheme.put("other_marks", new String[]{"\u0a02", "\u0a03", "\u0a01"});
        hashScheme.put("virama", new String[]{"\u0a4d"});
        hashScheme.put("consonants", new String[]{"\u0a15", "\u0a16", "\u0a17", "\u0a18", "\u0a19", "\u0a1a", "\u0a1b", "\u0a1c", "\u0a1d", "\u0a1e", "\u0a1f", "\u0a20", "\u0a21", "\u0a22", "\u0a23", "\u0a24", "\u0a25", "\u0a26", "\u0a27", "\u0a28", "\u0a2a", "\u0a2b", "\u0a2c", "\u0a2d", "\u0a2e", "\u0a2f", "\u0a30", "\u0a32", "\u0a35", "\u0a36", "\u0a36", "\u0a38", "\u0a39", "\u0a33", "\u0a15\u0a4d\u0a36", "\u0a1c\u0a4d\u0a1e"});
        hashScheme.put("symbols", new String[]{"\u0a66", "\u0a67", "\u0a68", "\u0a69", "\u0a6a", "\u0a6b", "\u0a6c", "\u0a6d", "\u0a6e", "\u0a6f", "\u0950", "\u093d", "\u0964", "\u0965"});
        hashScheme.put("other", new String[]{"", "\u0a16", "\u0a17", "\u0a1c", "\u0a21", "", "\u0a2b", "", ""});
        this.schemes.put("gurmukhi", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"\u0c85", "\u0c86", "\u0c87", "\u0c88", "\u0c89", "\u0c8a", "\u0c8b", "\u0ce0", "\u0c8c", "\u0ce1", "\u0c8e", "\u0c8f", "\u0c90", "\u0c92", "\u0c93", "\u0c94"});
        hashScheme.put("vowel_marks", new String[]{"\u0cbe", "\u0cbf", "\u0cc0", "\u0cc1", "\u0cc2", "\u0cc3", "\u0cc4", "\u0ce2", "\u0ce3", "\u0cc6", "\u0cc7", "\u0cc8", "\u0cca", "\u0ccb", "\u0ccc"});
        hashScheme.put("other_marks", new String[]{"\u0c82", "\u0c83", "\u0901"});
        hashScheme.put("virama", new String[]{"\u0ccd"});
        hashScheme.put("consonants", new String[]{"\u0c95", "\u0c96", "\u0c97", "\u0c98", "\u0c99", "\u0c9a", "\u0c9b", "\u0c9c", "\u0c9d", "\u0c9e", "\u0c9f", "\u0ca0", "\u0ca1", "\u0ca2", "\u0ca3", "\u0ca4", "\u0ca5", "\u0ca6", "\u0ca7", "\u0ca8", "\u0caa", "\u0cab", "\u0cac", "\u0cad", "\u0cae", "\u0caf", "\u0cb0", "\u0cb2", "\u0cb5", "\u0cb6", "\u0cb7", "\u0cb8", "\u0cb9", "\u0cb3", "\u0c95\u0ccd\u0cb7", "\u0c9c\u0ccd\u0c9e"});
        hashScheme.put("symbols", new String[]{"\u0ce6", "\u0ce7", "\u0ce8", "\u0ce9", "\u0cea", "\u0ceb", "\u0cec", "\u0ced", "\u0cee", "\u0cef", "\u0c93\u0c82", "\u0cbd", "\u0964", "\u0965"});
        hashScheme.put("other", new String[]{"", "", "", "", "", "", "\u0cab", "", "\u0cb1"});
        this.schemes.put("kannada", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"\u0d05", "\u0d06", "\u0d07", "\u0d08", "\u0d09", "\u0d0a", "\u0d0b", "\u0d60", "\u0d0c", "\u0d61", "\u0d0e", "\u0d0f", "\u0d10", "\u0d12", "\u0d13", "\u0d14"});
        hashScheme.put("vowel_marks", new String[]{"\u0d3e", "\u0d3f", "\u0d40", "\u0d41", "\u0d42", "\u0d43", "\u0d44", "\u0d62", "\u0d63", "\u0d46", "\u0d47", "\u0d48", "\u0d4a", "\u0d4b", "\u0d4c"});
        hashScheme.put("other_marks", new String[]{"\u0d02", "\u0d03", "\u0901"});
        hashScheme.put("virama", new String[]{"\u0d4d"});
        hashScheme.put("consonants", new String[]{"\u0d15", "\u0d16", "\u0d17", "\u0d18", "\u0d19", "\u0d1a", "\u0d1b", "\u0d1c", "\u0d1d", "\u0d1e", "\u0d1f", "\u0d20", "\u0d21", "\u0d22", "\u0d23", "\u0d24", "\u0d25", "\u0d26", "\u0d27", "\u0d28", "\u0d2a", "\u0d2b", "\u0d2c", "\u0d2d", "\u0d2e", "\u0d2f", "\u0d30", "\u0d32", "\u0d35", "\u0d36", "\u0d37", "\u0d38", "\u0d39", "\u0d33", "\u0d15\u0d4d\u0d37", "\u0d1c\u0d4d\u0d1e"});
        hashScheme.put("symbols", new String[]{"\u0d66", "\u0d67", "\u0d68", "\u0d69", "\u0d6a", "\u0d6b", "\u0d6c", "\u0d6d", "\u0d6e", "\u0d6f", "\u0d13\u0d02", "\u0d3d", "\u0964", "\u0965"});
        hashScheme.put("other", new String[]{"", "", "", "", "", "", "", "", "\u0d31"});
        this.schemes.put("malayalam", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"\u0b05", "\u0b06", "\u0b07", "\u0b08", "\u0b09", "\u0b0a", "\u0b0b", "\u0b60", "\u0b0c", "\u0b61", "", "\u0b0f", "\u0b10", "", "\u0b13", "\u0b14"});
        hashScheme.put("vowel_marks", new String[]{"\u0b3e", "\u0b3f", "\u0b40", "\u0b41", "\u0b42", "\u0b43", "\u0b44", "\u0b62", "\u0b63", "", "\u0b47", "\u0b48", "", "\u0b4b", "\u0b4c"});
        hashScheme.put("other_marks", new String[]{"\u0b02", "\u0b03", "\u0b01"});
        hashScheme.put("virama", new String[]{"\u0b4d"});
        hashScheme.put("consonants", new String[]{"\u0b15", "\u0b16", "\u0b17", "\u0b18", "\u0b19", "\u0b1a", "\u0b1b", "\u0b1c", "\u0b1d", "\u0b1e", "\u0b1f", "\u0b20", "\u0b21", "\u0b22", "\u0b23", "\u0b24", "\u0b25", "\u0b26", "\u0b27", "\u0b28", "\u0b2a", "\u0b2b", "\u0b2c", "\u0b2d", "\u0b2e", "\u0b2f", "\u0b30", "\u0b32", "\u0b35", "\u0b36", "\u0b37", "\u0b38", "\u0b39", "\u0b33", "\u0b15\u0b4d\u0b37", "\u0b1c\u0b4d\u0b1e"});
        hashScheme.put("symbols", new String[]{"\u0b66", "\u0b67", "\u0b68", "\u0b69", "\u0b6a", "\u0b6b", "\u0b6c", "\u0b6d", "\u0b6e", "\u0b6f", "\u0b13\u0b02", "\u0b3d", "\u0964", "\u0965"});
        hashScheme.put("other", new String[]{"", "", "", "", "\u0b21", "\u0b22", "", "\u0b2f", ""});
        this.schemes.put("oriya", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"\u0b85", "\u0b86", "\u0b87", "\u0b88", "\u0b89", "\u0b8a", "", "", "", "", "\u0b8e", "\u0b8f", "\u0b90", "\u0b92", "\u0b93", "\u0b94"});
        hashScheme.put("vowel_marks", new String[]{"\u0bbe", "\u0bbf", "\u0bc0", "\u0bc1", "\u0bc2", "", "", "", "", "\u0bc6", "\u0bc7", "\u0bc8", "\u0bca", "\u0bcb", "\u0bcc"});
        hashScheme.put("other_marks", new String[]{"\u0b82", "\u0b83", ""});
        hashScheme.put("virama", new String[]{"\u0bcd"});
        hashScheme.put("consonants", new String[]{"\u0b95", "\u0b95", "\u0b95", "\u0b95", "\u0b99", "\u0b9a", "\u0b9a", "\u0b9c", "\u0b9a", "\u0b9e", "\u0b9f", "\u0b9f", "\u0b9f", "\u0b9f", "\u0ba3", "\u0ba4", "\u0ba4", "\u0ba4", "\u0ba4", "\u0ba8", "\u0baa", "\u0baa", "\u0baa", "\u0baa", "\u0bae", "\u0baf", "\u0bb0", "\u0bb2", "\u0bb5", "\u0bb6", "\u0bb7", "\u0bb8", "\u0bb9", "\u0bb3", "\u0b95\u0bcd\u0bb7", "\u0b9c\u0bcd\u0b9e"});
        hashScheme.put("symbols", new String[]{"\u0be6", "\u0be7", "\u0be8", "\u0be9", "\u0bea", "\u0beb", "\u0bec", "\u0bed", "\u0bee", "\u0bef", "\u0bd0", "\u093d", "\u0964", "\u0965"});
        hashScheme.put("other", new String[]{"", "", "", "", "", "", "", "", "\u0bb1"});
        this.schemes.put("tamil", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"\u0c05", "\u0c06", "\u0c07", "\u0c08", "\u0c09", "\u0c0a", "\u0c0b", "\u0c60", "\u0c0c", "\u0c61", "\u0c0e", "\u0c0f", "\u0c10", "\u0c12", "\u0c13", "\u0c14"});
        hashScheme.put("vowel_marks", new String[]{"\u0c3e", "\u0c3f", "\u0c40", "\u0c41", "\u0c42", "\u0c43", "\u0c44", "\u0c62", "\u0c63", "\u0c46", "\u0c47", "\u0c48", "\u0c4a", "\u0c4b", "\u0c4c"});
        hashScheme.put("other_marks", new String[]{"\u0c02", "\u0c03", "\u0c01"});
        hashScheme.put("virama", new String[]{"\u0c4d"});
        hashScheme.put("consonants", new String[]{"\u0c15", "\u0c16", "\u0c17", "\u0c18", "\u0c19", "\u0c1a", "\u0c1b", "\u0c1c", "\u0c1d", "\u0c1e", "\u0c1f", "\u0c20", "\u0c21", "\u0c22", "\u0c23", "\u0c24", "\u0c25", "\u0c26", "\u0c27", "\u0c28", "\u0c2a", "\u0c2b", "\u0c2c", "\u0c2d", "\u0c2e", "\u0c2f", "\u0c30", "\u0c32", "\u0c35", "\u0c36", "\u0c37", "\u0c38", "\u0c39", "\u0c33", "\u0c15\u0c4d\u0c37", "\u0c1c\u0c4d\u0c1e"});
        hashScheme.put("symbols", new String[]{"\u0c66", "\u0c67", "\u0c68", "\u0c69", "\u0c6a", "\u0c6b", "\u0c6c", "\u0c6d", "\u0c6e", "\u0c6f", "\u0c13\u0c02", "\u0c3d", "\u0964", "\u0965"});
        hashScheme.put("other", new String[]{"", "", "", "", "", "", "", "", "\u0c31"});
        this.schemes.put("telugu", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"a", "\u0101", "i", "\u012b", "u", "\u016b", "\u1e5b", "\u1e5d", "\u1e37", "\u1e39", "", "e", "ai", "", "o", "au"});
        hashScheme.put("other_marks", new String[]{"\u1e43", "\u1e25", "~"});
        hashScheme.put("virama", new String[]{""});
        hashScheme.put("consonants", new String[]{"k", "kh", "g", "gh", "\u1e45", "c", "ch", "j", "jh", "\u00f1", "\u1e6d", "\u1e6dh", "\u1e0d", "\u1e0dh", "\u1e47", "t", "th", "d", "dh", "n", "p", "ph", "b", "bh", "m", "y", "r", "l", "v", "\u015b", "\u1e63", "s", "h", "\u1e3b", "k\u1e63", "j\u00f1"});
        hashScheme.put("symbols", new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "o\u1e43", "'", "\u0964", "\u0965"});
        this.schemes.put("iast", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"a", "A", "i", "I", "u", "U", "RRi", "RRI", "LLi", "LLI", "", "e", "ai", "", "o", "au"});
        hashScheme.put("other_marks", new String[]{"M", "H", ".N"});
        hashScheme.put("virama", new String[]{""});
        hashScheme.put("consonants", new String[]{"k", "kh", "g", "gh", "~N", "ch", "Ch", "j", "jh", "~n", "T", "Th", "D", "Dh", "N", "t", "th", "d", "dh", "n", "p", "ph", "b", "bh", "m", "y", "r", "l", "v", "sh", "Sh", "s", "h", "L", "kSh", "j~n"});
        hashScheme.put("symbols", new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "OM", ".a", "|", "||"});
        hashScheme.put("candra", new String[]{".c"});
        hashScheme.put("zwj", new String[]{"{}"});
        hashScheme.put("skip", new String[]{"_"});
        hashScheme.put("accent", new String[]{"\\'", "\\_"});
        hashScheme.put("combo_accent", new String[]{"\\'H", "\\_H", "\\'M", "\\_M"});
        hashScheme.put("other", new String[]{"q", "K", "G", "z", ".D", ".Dh", "f", "Y", "R"});
        this.schemes.put("itrans", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"a", "A", "i", "I", "u", "U", "R", "RR", "lR", "lRR", "", "e", "ai", "", "o", "au"});
        hashScheme.put("other_marks", new String[]{"M", "H", "~"});
        hashScheme.put("virama", new String[]{""});
        hashScheme.put("consonants", new String[]{"k", "kh", "g", "gh", "G", "c", "ch", "j", "jh", "J", "T", "Th", "D", "Dh", "N", "t", "th", "d", "dh", "n", "p", "ph", "b", "bh", "m", "y", "r", "l", "v", "z", "S", "s", "h", "L", "kS", "jJ"});
        hashScheme.put("symbols", new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "OM", "'", "|", "||"});
        this.schemes.put("hk", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"a", "A", "i", "I", "u", "U", "f", "F", "x", "X", "", "e", "E", "", "o", "O"});
        hashScheme.put("other_marks", new String[]{"M", "H", "~"});
        hashScheme.put("virama", new String[]{""});
        hashScheme.put("consonants", new String[]{"k", "K", "g", "G", "N", "c", "C", "j", "J", "Y", "w", "W", "q", "Q", "R", "t", "T", "d", "D", "n", "p", "P", "b", "B", "m", "y", "r", "l", "v", "S", "z", "s", "h", "L", "kz", "jY"});
        hashScheme.put("symbols", new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "oM", "'", ".", ".."});
        this.schemes.put("slp1", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"a", "aa", "i", "ii", "u", "uu", ".r", ".rr", ".li", ".ll", "", "e", "ai", "", "o", "au"});
        hashScheme.put("other_marks", new String[]{".m", ".h", ""});
        hashScheme.put("virama", new String[]{""});
        hashScheme.put("consonants", new String[]{"k", "kh", "g", "gh", "\"n", "c", "ch", "j", "jh", "~n", ".t", ".th", ".d", ".d", ".n", "t", "th", "d", "dh", "n", "p", "ph", "b", "bh", "m", "y", "r", "l", "v", "~s", ".s", "s", "h", "L", "k.s", "j~n"});
        hashScheme.put("symbols", new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "o.m", "'", "|", "||"});
        this.schemes.put("velthuis", hashScheme);
        hashScheme = new HashScheme();
        hashScheme.put("vowels", new String[]{"a", "A", "i", "I", "u", "U", "q", "Q", "L", "", "", "e", "E", "", "o", "O"});
        hashScheme.put("other_marks", new String[]{"M", "H", "z"});
        hashScheme.put("virama", new String[]{""});
        hashScheme.put("consonants", new String[]{"k", "K", "g", "G", "f", "c", "C", "j", "J", "F", "t", "T", "d", "D", "N", "w", "W", "x", "X", "n", "p", "P", "b", "B", "m", "y", "r", "l", "v", "S", "R", "s", "h", "", "kR", "jF"});
        hashScheme.put("symbols", new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "oM", "'", "|", "||"});
        this.schemes.put("wx", hashScheme);
    }

    private void initializeAlternates() {
        AlternateMap alternateMap = new AlternateMap();
        alternateMap.put("A", new String[]{"aa"});
        alternateMap.put("I", new String[]{"ii", "ee"});
        alternateMap.put("U", new String[]{"uu", "oo"});
        alternateMap.put("RRi", new String[]{"R^i"});
        alternateMap.put("RRI", new String[]{"R^I"});
        alternateMap.put("LLi", new String[]{"L^i"});
        alternateMap.put("LLI", new String[]{"L^I"});
        alternateMap.put("M", new String[]{".m", ".n"});
        alternateMap.put("~N", new String[]{"N^"});
        alternateMap.put("ch", new String[]{"c"});
        alternateMap.put("Ch", new String[]{"C", "chh"});
        alternateMap.put("~n", new String[]{"JN"});
        alternateMap.put("v", new String[]{"w"});
        alternateMap.put("Sh", new String[]{"S", "shh"});
        alternateMap.put("kSh", new String[]{"kS", "x"});
        alternateMap.put("j~n", new String[]{"GY", "dny"});
        alternateMap.put("OM", new String[]{"AUM"});
        alternateMap.put("\\_", new String[]{"\\`"});
        alternateMap.put("\\_H", new String[]{"\\`H"});
        alternateMap.put("\\'M", new String[]{"\\'.m", "\\'.n"});
        alternateMap.put("\\_M", new String[]{"\\_.m", "\\_.n", "\\`M", "\\`.m", "\\`.n"});
        alternateMap.put(".a", new String[]{"~"});
        alternateMap.put("|", new String[]{"."});
        alternateMap.put("||", new String[]{".."});
        alternateMap.put("z", new String[]{"J"});
        this.allAlternates.put("itrans", alternateMap);
    }

    public boolean isRomanScheme(String string) {
        Boolean bl = this.romanSchemes.get(string);
        return bl != null && bl != false;
    }

    public void addBrahmicScheme(String string, Scheme scheme) {
        this.schemes.put(string, scheme);
    }

    public void addRomanScheme(String string, Scheme scheme) {
        if (scheme.get("vowel_marks") == null) {
            scheme.put("vowel_marks", Arrays.copyOfRange((Object[])scheme.get("vowels"), 1, ((String[])scheme.get("vowels")).length));
        }
        this.schemes.put(string, scheme);
        this.romanSchemes.put(string, true);
    }

    private void initializeSpecialSchemes() {
        Scheme scheme = ((Scheme)this.schemes.get("iast")).cheapCopy();
        scheme.put("vowels", new String[]{"a", "\u0101", "i", "\u012b", "u", "\u016b", "\u1e5b", "\u1e5d", "\u1e37", "\u1e39", "e", "\u0113", "ai", "o", "\u014d", "au"});
        this.schemes.put("kolkata", scheme);
        String[] stringArray = new String[]{"iast", "itrans", "hk", "kolkata", "slp1", "velthuis", "wx"};
        for (String string : stringArray) {
            this.addRomanScheme(string, (Scheme)this.schemes.get(string));
        }
        Scheme scheme2 = ((Scheme)this.schemes.get("itrans")).cheapCopy();
        scheme2.put("vowels", new String[]{"a", "A", "i", "I", "u", "U", "Ri", "RRI", "LLi", "LLi", "e", "E", "ai", "o", "O", "au"});
        scheme2.put("vowel_marks", Arrays.copyOfRange((Object[])scheme2.get("vowels"), 1, ((String[])scheme2.get("vowels")).length));
        this.allAlternates.put("itrans_dravidian", this.allAlternates.get("itrans"));
        this.addRomanScheme("itrans_dravidian", scheme2);
    }

    private TMap makeMap(String string, String string2, Options options) {
        AlternateMap alternateMap = this.allAlternates.get(string) != null ? (AlternateMap)this.allAlternates.get(string) : new AlternateMap();
        SMap sMap = new SMap();
        Scheme scheme = (Scheme)this.schemes.get(string);
        SMap sMap2 = new SMap();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        SMap sMap3 = new SMap();
        Scheme scheme2 = (Scheme)this.schemes.get(string2);
        for (Map.Entry entry : scheme.entrySet()) {
            String string3 = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            String[] stringArray2 = (String[])scheme2.get(string3);
            if (stringArray2 == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                String string4 = stringArray[i];
                String string5 = stringArray2[i];
                String[] stringArray3 = alternateMap.get(string4) != null ? (String[])alternateMap.get(string4) : new String[]{};
                arrayList.add(string4.length());
                for (String string6 : stringArray3) {
                    arrayList.add(string6.length());
                }
                if (string3.equals("vowel_marks") || string3.equals("virama")) {
                    sMap3.put(string4, string5);
                    for (String string6 : stringArray3) {
                        sMap3.put(string6, string5);
                    }
                    continue;
                }
                sMap2.put(string4, string5);
                for (String string6 : stringArray3) {
                    sMap2.put(string6, string5);
                }
                if (!string3.equals("consonants") && !string3.equals("other")) continue;
                sMap.put(string4, string5);
                for (String string6 : stringArray3) {
                    sMap.put(string6, string5);
                }
            }
        }
        TMap tMap = new TMap();
        tMap.consonants = sMap;
        tMap.fromRoman = this.isRomanScheme(string);
        tMap.letters = sMap2;
        tMap.marks = sMap3;
        tMap.maxTokenLength = (Integer)Collections.max(arrayList);
        tMap.toRoman = this.isRomanScheme(string2);
        tMap.virama = (String[])scheme2.get("virama");
        return tMap;
    }

    private String transliterateRoman(String string, TMap tMap, Options options) {
        StringBuilder stringBuilder = new StringBuilder();
        SMap sMap = tMap.consonants;
        int n = string.length();
        boolean bl = false;
        SMap sMap2 = tMap.letters;
        SMap sMap3 = tMap.marks;
        int n2 = tMap.maxTokenLength;
        Boolean bl2 = (Boolean)options.get("skip_sgml");
        Boolean bl3 = (Boolean)options.get("syncope");
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl4 = tMap.toRoman;
        String[] stringArray = tMap.virama;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        block0: for (int i = 0; i < n || stringBuilder2.length() > 0; ++i) {
            int n3 = n2 - stringBuilder2.length();
            if (n3 > 0 && i < n) {
                stringBuilder2.append(string.charAt(i));
                if (n3 > 1) continue;
            }
            for (int j = 0; j < n2; ++j) {
                String string2 = stringBuilder2.substring(0, Math.min(n2 - j, stringBuilder2.length()));
                if (bl5) {
                    bl5 = !string2.equals(">");
                } else if (string2.equals("<")) {
                    bl5 = bl2;
                } else if (string2.equals("##")) {
                    bl7 = !bl7;
                    stringBuilder2 = stringBuilder2.delete(0, 2);
                    continue block0;
                }
                bl6 = bl5 || bl7;
                String string3 = (String)sMap2.get(string2);
                if (string3 != null && !bl6) {
                    if (bl4) {
                        stringBuilder.append(string3);
                    } else {
                        if (bl) {
                            String string4 = (String)sMap3.get(string2);
                            if (string4 != null) {
                                stringBuilder.append(string4);
                            } else if (!string2.equals("a")) {
                                stringBuilder.append(stringArray[0]);
                                stringBuilder.append(string3);
                            }
                        } else {
                            stringBuilder.append(string3);
                        }
                        bl = sMap.get(string2) != null;
                    }
                    stringBuilder2 = stringBuilder2.delete(0, n2 - j);
                    continue block0;
                }
                if (j != n2 - 1) continue;
                if (bl) {
                    bl = false;
                    if (!bl3.booleanValue()) {
                        stringBuilder.append(stringArray[0]);
                    }
                }
                stringBuilder.append(string2);
                stringBuilder2 = stringBuilder2.delete(0, 1);
            }
        }
        if (bl && !bl3.booleanValue()) {
            stringBuilder.append(stringArray[0]);
        }
        return stringBuilder.toString();
    }

    private String transliterateBrahmic(String string, TMap tMap, Options options) {
        StringBuilder stringBuilder = new StringBuilder();
        SMap sMap = tMap.consonants;
        boolean bl = false;
        boolean bl2 = false;
        SMap sMap2 = tMap.letters;
        SMap sMap3 = tMap.marks;
        boolean bl3 = tMap.toRoman;
        boolean bl4 = false;
        for (int i = 0; i < string.length(); ++i) {
            String string2 = Character.toString(string.charAt(i));
            if (string2.equals("#")) {
                if (bl) {
                    bl4 = !bl4;
                    bl = false;
                } else {
                    bl = true;
                }
                if (!bl2) continue;
                stringBuilder.append('a');
                bl2 = false;
                continue;
            }
            if (bl4) {
                stringBuilder.append(string2);
                continue;
            }
            String string3 = (String)sMap3.get(string2);
            if (string3 != null) {
                stringBuilder.append(string3);
                bl2 = false;
                continue;
            }
            if (bl) {
                stringBuilder.append('#');
                bl = false;
            }
            if (bl2) {
                stringBuilder.append('a');
                bl2 = false;
            }
            if ((string3 = (String)sMap2.get(string2)) != null && !string3.equals("")) {
                stringBuilder.append(string3);
                bl2 = bl3 && sMap.get(string2) != null;
                continue;
            }
            stringBuilder.append(string2);
        }
        if (bl2) {
            stringBuilder.append('a');
        }
        return stringBuilder.toString();
    }

    public String t(String string, String string2, String string3, Options options) {
        TMap tMap;
        if (options == null) {
            options = new HashOptions();
        }
        Options options2 = this.cache.options != null ? this.cache.options : new HashOptions();
        boolean bl = this.cache.from != null && this.cache.from.equals(string2) && this.cache.to != null && this.cache.to.equals(string3);
        for (Map.Entry entry : this.defaults.entrySet()) {
            String string4 = (String)entry.getKey();
            Object v = entry.getValue();
            if (options.get(string4) != null) {
                v = options.get(string4);
            }
            options.put(string4, v);
            if (v.equals(options2.get(string4))) continue;
            bl = false;
        }
        if (bl) {
            tMap = this.cache.map;
        } else {
            tMap = this.makeMap(string2, string3, options);
            this.cache.from = string2;
            this.cache.map = tMap;
            this.cache.options = options;
            this.cache.to = string3;
        }
        if (string2.equals("itrans")) {
            string = string.replaceAll("\\{\\\\m\\+\\}", ".h.N");
            string = string.replaceAll("\\.h", "");
            string = string.replaceAll("\\\\([^'`_]|$)", "##$1##");
        }
        if (tMap.fromRoman) {
            return this.transliterateRoman(string, tMap, options);
        }
        return this.transliterateBrahmic(string, tMap, options);
    }

    public String t(String string, String string2, String string3) {
        return this.t(string, string2, string3, null);
    }

    private class TMap {
        public boolean fromRoman;
        public boolean toRoman;
        public SMap consonants;
        public SMap letters;
        public SMap marks;
        public String[] virama;
        public int maxTokenLength;

        private TMap() {
        }
    }

    private class SMap
    extends HashMap<String, String> {
        private SMap() {
        }
    }

    private class Cache {
        public String from = null;
        public String to = null;
        public TMap map = null;
        public Options options = null;

        private Cache() {
        }
    }

    private class Alternates
    extends HashMap<String, AlternateMap> {
        private Alternates() {
        }
    }

    private class AlternateMap
    extends HashMap<String, String[]> {
        private AlternateMap() {
        }
    }

    public class Schemes
    extends HashMap<String, Scheme> {
    }

    public static class HashScheme
    extends HashMap<String, String[]>
    implements Scheme {
        @Override
        public Scheme cheapCopy() {
            HashScheme hashScheme = new HashScheme();
            for (Map.Entry entry : this.entrySet()) {
                String[] stringArray = (String[])entry.getValue();
                hashScheme.put(entry.getKey(), Arrays.copyOf(stringArray, stringArray.length));
            }
            return hashScheme;
        }
    }

    public static interface Scheme
    extends Map<String, String[]> {
        public Scheme cheapCopy();
    }

    public static class HashOptions
    extends HashMap<String, Object>
    implements Options {
        public HashOptions set(String string, Object object) {
            this.put(string, object);
            return this;
        }
    }

    public static interface Options
    extends Map<String, Object> {
    }
}

