/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.facebook;

import com.github.scribejava.apis.FacebookApi;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class FacebookService
extends OAuth20Service {
    @Deprecated
    public FacebookService(FacebookApi api, String apiKey, String apiSecret, String callback, String defaultScope, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        this(api, apiKey, apiSecret, callback, defaultScope, responseType, null, userAgent, httpClientConfig, httpClient);
    }

    public FacebookService(FacebookApi api, String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super((DefaultApi20)api, apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
    }

    public void signRequest(String accessToken, OAuthRequest request) {
        super.signRequest(accessToken, request);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(this.getApiSecret().getBytes(), "HmacSHA256");
            mac.init(secretKey);
            Formatter appsecretProof = new Formatter();
            for (byte b : mac.doFinal(accessToken.getBytes())) {
                appsecretProof.format("%02x", b);
            }
            request.addParameter("appsecret_proof", appsecretProof.toString());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("There is a problem while generating Facebook appsecret_proof.", e);
        }
    }
}

