/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuthService;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRequest {
    public static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE = "Content-Type";
    protected static final String CONTENT_LENGTH = "Content-Length";
    private static final String OAUTH_PREFIX = "oauth_";
    private final String url;
    private final Verb verb;
    private final ParameterList querystringParams = new ParameterList();
    private final ParameterList bodyParams = new ParameterList();
    private final Map<String, String> headers = new HashMap<String, String>();
    private boolean connectionKeepAlive;
    private boolean followRedirects = true;
    private final OAuthService service;
    private String payload;
    private String charset;
    private byte[] bytePayload;
    private final Map<String, String> oauthParameters = new HashMap<String, String>();
    private String realm;

    public AbstractRequest(Verb verb, String url, OAuthService service) {
        this.verb = verb;
        this.url = url;
        this.service = service;
    }

    public void addOAuthParameter(String key, String value) {
        this.oauthParameters.put(this.checkKey(key), value);
    }

    private String checkKey(String key) {
        if (key.startsWith(OAUTH_PREFIX) || key.equals("scope") || key.equals("realm")) {
            return key;
        }
        throw new IllegalArgumentException(String.format("OAuth parameters must either be '%s', '%s' or start with '%s'", "scope", "realm", OAUTH_PREFIX));
    }

    public Map<String, String> getOauthParameters() {
        return this.oauthParameters;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getCompleteUrl() {
        return this.querystringParams.appendTo(this.url);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addBodyParameter(String key, String value) {
        this.bodyParams.add(key, value);
    }

    public void addQuerystringParameter(String key, String value) {
        this.querystringParams.add(key, value);
    }

    public void addParameter(String key, String value) {
        if (this.hasBodyContent()) {
            this.bodyParams.add(key, value);
        } else {
            this.querystringParams.add(key, value);
        }
    }

    protected boolean hasBodyContent() {
        return this.verb == Verb.PUT || this.verb == Verb.POST;
    }

    public void addPayload(String payload) {
        this.payload = payload;
    }

    public void addPayload(byte[] payload) {
        this.bytePayload = (byte[])payload.clone();
    }

    public ParameterList getQueryStringParams() {
        try {
            ParameterList result = new ParameterList();
            String queryString = new URL(this.url).getQuery();
            result.addQuerystring(queryString);
            result.addAll(this.querystringParams);
            return result;
        }
        catch (MalformedURLException mue) {
            throw new OAuthException("Malformed URL", mue);
        }
    }

    public ParameterList getBodyParams() {
        return this.bodyParams;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSanitizedUrl() {
        if (this.url.startsWith("http://") && (this.url.endsWith(":80") || this.url.contains(":80/"))) {
            return this.url.replaceAll("\\?.*", "").replaceAll(":80", "");
        }
        if (this.url.startsWith("https://") && (this.url.endsWith(":443") || this.url.contains(":443/"))) {
            return this.url.replaceAll("\\?.*", "").replaceAll(":443", "");
        }
        return this.url.replaceAll("\\?.*", "");
    }

    public String getBodyContents() {
        try {
            return new String(this.getByteBodyContents(), this.getCharset());
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException("Unsupported Charset: " + this.charset, uee);
        }
    }

    byte[] getByteBodyContents() {
        if (this.bytePayload != null) {
            return this.bytePayload;
        }
        String body = this.payload == null ? this.bodyParams.asFormUrlEncodedString() : this.payload;
        try {
            return body.getBytes(this.getCharset());
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException("Unsupported Charset: " + this.getCharset(), uee);
        }
    }

    public String toString() {
        return String.format("@Request(%s %s)", new Object[]{this.getVerb(), this.getUrl()});
    }

    public Verb getVerb() {
        return this.verb;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getCharset() {
        return this.charset == null ? Charset.defaultCharset().name() : this.charset;
    }

    public void setCharset(String charsetName) {
        this.charset = charsetName;
    }

    public void setConnectionKeepAlive(boolean connectionKeepAlive) {
        this.connectionKeepAlive = connectionKeepAlive;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public boolean isConnectionKeepAlive() {
        return this.connectionKeepAlive;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public OAuthService getService() {
        return this.service;
    }
}

