/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OAuthRequestTest {
    private OAuthRequest request;

    @Before
    public void setUp() {
        this.request = new OAuthRequest(Verb.GET, "http://example.com");
    }

    @Test
    public void shouldAddOAuthParamters() {
        this.request.addOAuthParameter("oauth_token", "token");
        this.request.addOAuthParameter("oauth_nonce", "nonce");
        this.request.addOAuthParameter("oauth_timestamp", "ts");
        this.request.addOAuthParameter("scope", "feeds");
        this.request.addOAuthParameter("realm", "some-realm");
        Assert.assertEquals((long)5L, (long)this.request.getOauthParameters().size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfParameterIsNotOAuth() {
        this.request.addOAuthParameter("otherParam", "value");
    }

    @Test
    public void shouldNotSentHeaderTwice() {
        Assert.assertTrue((boolean)this.request.getHeaders().isEmpty());
        this.request.addHeader("HEADER-NAME", "first");
        this.request.addHeader("header-name", "middle");
        this.request.addHeader("Header-Name", "last");
        Assert.assertEquals((long)1L, (long)this.request.getHeaders().size());
        Assert.assertTrue((boolean)this.request.getHeaders().containsKey("HEADER-NAME"));
        Assert.assertTrue((boolean)this.request.getHeaders().containsKey("header-name"));
        Assert.assertTrue((boolean)this.request.getHeaders().containsKey("Header-Name"));
        Assert.assertEquals((Object)"last", this.request.getHeaders().get("HEADER-NAME"));
        Assert.assertEquals((Object)"last", this.request.getHeaders().get("header-name"));
        Assert.assertEquals((Object)"last", this.request.getHeaders().get("Header-Name"));
    }
}

