/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.ahc;

import com.github.scribejava.core.model.HttpClient;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.httpclient.ahc.AhcHttpClientConfig;
import com.github.scribejava.httpclient.ahc.OAuthAsyncCompletionHandler;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;

public class AhcHttpClient
implements HttpClient {
    private final AsyncHttpClient client;

    public AhcHttpClient(AhcHttpClientConfig ahcConfig) {
        this.client = new DefaultAsyncHttpClient(ahcConfig.getClientConfig());
    }

    public AhcHttpClient(DefaultAsyncHttpClient ahcClient) {
        this.client = ahcClient;
    }

    public void close() throws IOException {
        this.client.close();
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        BoundRequestBuilder boundRequestBuilder;
        switch (httpVerb) {
            case GET: {
                boundRequestBuilder = this.client.prepareGet(completeUrl);
                break;
            }
            case POST: {
                BoundRequestBuilder requestBuilder = this.client.preparePost(completeUrl);
                if (!headers.containsKey("Content-Type")) {
                    requestBuilder = (BoundRequestBuilder)requestBuilder.addHeader((CharSequence)"Content-Type", "application/x-www-form-urlencoded");
                }
                boundRequestBuilder = (BoundRequestBuilder)requestBuilder.setBody(bodyContents);
                break;
            }
            default: {
                throw new IllegalArgumentException("message build error: unknown verb type");
            }
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            boundRequestBuilder.addHeader((CharSequence)header.getKey(), header.getValue());
        }
        if (userAgent != null) {
            boundRequestBuilder.setHeader((CharSequence)"User-Agent", userAgent);
        }
        return boundRequestBuilder.execute(new OAuthAsyncCompletionHandler<T>(callback, converter));
    }
}

