/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.ning;

import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OAuthAsyncCompletionHandler<T>
extends AsyncCompletionHandler<T> {
    private final OAuthAsyncRequestCallback<T> callback;
    private final OAuthRequest.ResponseConverter<T> converter;

    public OAuthAsyncCompletionHandler(OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        this.callback = callback;
        this.converter = converter;
    }

    public T onCompleted(com.ning.http.client.Response ningResponse) throws IOException {
        Response t;
        FluentCaseInsensitiveStringsMap map = ningResponse.getHeaders();
        HashMap headersMap = new HashMap();
        for (Map.Entry header : map) {
            StringBuilder value = new StringBuilder();
            for (String str : (List)header.getValue()) {
                value.append(str);
            }
            headersMap.put(header.getKey(), value.toString());
        }
        Response response = new Response(ningResponse.getStatusCode(), ningResponse.getStatusText(), headersMap, ningResponse.getResponseBodyAsStream());
        Object object = t = this.converter == null ? response : this.converter.convert(response);
        if (this.callback != null) {
            this.callback.onCompleted((Object)t);
        }
        return (T)t;
    }

    public void onThrowable(Throwable t) {
        if (this.callback != null) {
            this.callback.onThrowable(t);
        }
    }
}

