/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.ning;

import com.github.scribejava.core.httpclient.AbstractAsyncOnlyHttpClient;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.httpclient.ning.NingHttpClientConfig;
import com.github.scribejava.httpclient.ning.OAuthAsyncCompletionHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class NingHttpClient
extends AbstractAsyncOnlyHttpClient {
    private final AsyncHttpClient client;

    public NingHttpClient() {
        this(NingHttpClientConfig.defaultConfig());
    }

    public NingHttpClient(NingHttpClientConfig ningConfig) {
        String ningAsyncHttpProviderClassName = ningConfig.getNingAsyncHttpProviderClassName();
        AsyncHttpClientConfig config = ningConfig.getConfig();
        if (ningAsyncHttpProviderClassName == null) {
            this.client = config == null ? new AsyncHttpClient() : new AsyncHttpClient(config);
        } else {
            if (config == null) {
                config = new AsyncHttpClientConfig.Builder().build();
            }
            this.client = new AsyncHttpClient(ningAsyncHttpProviderClassName, config);
        }
    }

    public NingHttpClient(AsyncHttpClient client) {
        this.client = client;
    }

    public void close() {
        this.client.close();
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, requestBuilder -> requestBuilder.setBody(bodyContents), callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, requestBuilder -> requestBuilder.setBody(bodyContents), callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, requestBuilder -> {
            AsyncHttpClient.BoundRequestBuilder cfr_ignored_0 = (AsyncHttpClient.BoundRequestBuilder)requestBuilder.setBody(bodyContents);
        }, callback, converter);
    }

    private <T> Future<T> doExecuteAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, Consumer<AsyncHttpClient.BoundRequestBuilder> bodySetter, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        AsyncHttpClient.BoundRequestBuilder boundRequestBuilder;
        switch (httpVerb) {
            case GET: {
                boundRequestBuilder = this.client.prepareGet(completeUrl);
                break;
            }
            case POST: {
                boundRequestBuilder = this.client.preparePost(completeUrl);
                break;
            }
            case PUT: {
                boundRequestBuilder = this.client.preparePut(completeUrl);
                break;
            }
            case DELETE: {
                boundRequestBuilder = this.client.prepareDelete(completeUrl);
                break;
            }
            default: {
                throw new IllegalArgumentException("message build error: unknown verb type");
            }
        }
        if (httpVerb.isPermitBody()) {
            if (!headers.containsKey("Content-Type")) {
                boundRequestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded");
            }
            bodySetter.accept(boundRequestBuilder);
        }
        headers.forEach((headerKey, headerValue) -> boundRequestBuilder.addHeader(headerKey, headerValue));
        if (userAgent != null) {
            boundRequestBuilder.setHeader("User-Agent", userAgent);
        }
        return boundRequestBuilder.execute(new OAuthAsyncCompletionHandler<T>(callback, converter));
    }
}

