/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.service;

import com.github.sevtech.cloud.storage.spring.exception.NoBucketException;
import com.github.sevtech.cloud.storage.spring.model.UploadFileRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorageService {
    private static final Logger log = LoggerFactory.getLogger(AbstractStorageService.class);

    protected InputStream clone(InputStream inputStream) {
        ByteArrayInputStream result = null;
        try {
            int readLength;
            inputStream.mark(0);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((readLength = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, readLength);
            }
            inputStream.reset();
            outputStream.flush();
            result = new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (Exception exception) {
            log.warn("Exception cloning inputStream", (Throwable)exception);
        }
        return result;
    }

    protected String getBucketName(String bucketName, String defaultBucketName) throws NoBucketException {
        return Optional.ofNullable(Optional.ofNullable(bucketName).orElse(defaultBucketName)).orElseThrow(() -> new NoBucketException("Bucket name not indicated"));
    }

    protected String getFilePath(UploadFileRequest request) {
        return request.getFolder().concat("/").concat(request.getName());
    }
}

