/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.constant;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.datatype.DataTypeFactory;
import com.github.sidhant92.boolparser.exception.InvalidDataType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ContainerDataType {
    primitive{

        @Override
        public <T> Optional<T> getValue(DataType dataType, Object value) {
            Optional result = DataTypeFactory.getDataType(dataType).getValue(value);
            if (!result.isPresent()) {
                log.error("Invalid data type for value {} for data type {}", (Object)value.toString(), (Object)dataType.name());
                throw new InvalidDataType(String.format("Invalid data type for value %s for data type %s", value, dataType.name()));
            }
            return result;
        }

        @Override
        public boolean isValid(DataType dataType, Object value) {
            return DataTypeFactory.getDataType(dataType).isValid(value);
        }
    };

    private static final Logger log;

    public abstract <T> Optional<T> getValue(DataType var1, Object var2);

    public abstract boolean isValid(DataType var1, Object var2);

    static {
        log = LoggerFactory.getLogger(ContainerDataType.class);
    }
}

