/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.datatype;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.datatype.AbstractDataType;
import com.github.sidhant92.boolparser.datatype.BooleanDataType;
import com.github.sidhant92.boolparser.datatype.DecimalDataType;
import com.github.sidhant92.boolparser.datatype.IntegerDataType;
import com.github.sidhant92.boolparser.datatype.LongDataType;
import com.github.sidhant92.boolparser.datatype.StringDataType;
import com.github.sidhant92.boolparser.datatype.VersionDataType;
import java.util.EnumMap;
import java.util.Map;

public class DataTypeFactory {
    private static final Map<DataType, AbstractDataType<?>> abstractDataTypeMap = new EnumMap(DataType.class);

    private DataTypeFactory() {
    }

    public static void initialize() {
        ObjectMapper objectMapper = new ObjectMapper();
        abstractDataTypeMap.put(DataType.STRING, new StringDataType(objectMapper));
        abstractDataTypeMap.put(DataType.INTEGER, new IntegerDataType(objectMapper));
        abstractDataTypeMap.put(DataType.DECIMAL, new DecimalDataType(objectMapper));
        abstractDataTypeMap.put(DataType.LONG, new LongDataType(objectMapper));
        abstractDataTypeMap.put(DataType.VERSION, new VersionDataType(objectMapper));
        abstractDataTypeMap.put(DataType.BOOLEAN, new BooleanDataType(objectMapper));
    }

    public static AbstractDataType getDataType(DataType dataType) {
        return abstractDataTypeMap.get((Object)dataType);
    }

    public static void register(AbstractDataType abstractDataType) {
        abstractDataTypeMap.put(abstractDataType.getDataType(), abstractDataType);
    }
}

