/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.domain;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.NodeType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.domain.Node;

public class ComparisonNode
extends Node {
    private final String field;
    private final Object value;
    private final Operator operator;
    private final DataType dataType;

    @Override
    public NodeType getTokenType() {
        return NodeType.COMPARISON;
    }

    public static ComparisonNodeBuilder builder() {
        return new ComparisonNodeBuilder();
    }

    public ComparisonNode(String field, Object value, Operator operator, DataType dataType) {
        this.field = field;
        this.value = value;
        this.operator = operator;
        this.dataType = dataType;
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public static class ComparisonNodeBuilder {
        private String field;
        private Object value;
        private Operator operator;
        private DataType dataType;

        ComparisonNodeBuilder() {
        }

        public ComparisonNodeBuilder field(String field) {
            this.field = field;
            return this;
        }

        public ComparisonNodeBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public ComparisonNodeBuilder operator(Operator operator) {
            this.operator = operator;
            return this;
        }

        public ComparisonNodeBuilder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public ComparisonNode build() {
            return new ComparisonNode(this.field, this.value, this.operator, this.dataType);
        }

        public String toString() {
            return "ComparisonNode.ComparisonNodeBuilder(field=" + this.field + ", value=" + this.value + ", operator=" + (Object)((Object)this.operator) + ", dataType=" + (Object)((Object)this.dataType) + ")";
        }
    }
}

