/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.domain;

import com.github.sidhant92.boolparser.constant.LogicalOperationType;
import com.github.sidhant92.boolparser.constant.NodeType;
import com.github.sidhant92.boolparser.domain.Node;

public class BooleanNode
extends Node {
    private Node left;
    private Node right;
    private LogicalOperationType operator;

    @Override
    public NodeType getTokenType() {
        return NodeType.BOOLEAN;
    }

    public static BooleanNodeBuilder builder() {
        return new BooleanNodeBuilder();
    }

    public BooleanNode(Node left, Node right, LogicalOperationType operator) {
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    public Node getLeft() {
        return this.left;
    }

    public Node getRight() {
        return this.right;
    }

    public LogicalOperationType getOperator() {
        return this.operator;
    }

    public void setLeft(Node left) {
        this.left = left;
    }

    public void setRight(Node right) {
        this.right = right;
    }

    public void setOperator(LogicalOperationType operator) {
        this.operator = operator;
    }

    public static class BooleanNodeBuilder {
        private Node left;
        private Node right;
        private LogicalOperationType operator;

        BooleanNodeBuilder() {
        }

        public BooleanNodeBuilder left(Node left) {
            this.left = left;
            return this;
        }

        public BooleanNodeBuilder right(Node right) {
            this.right = right;
            return this;
        }

        public BooleanNodeBuilder operator(LogicalOperationType operator) {
            this.operator = operator;
            return this;
        }

        public BooleanNode build() {
            return new BooleanNode(this.left, this.right, this.operator);
        }

        public String toString() {
            return "BooleanNode.BooleanNodeBuilder(left=" + this.left + ", right=" + this.right + ", operator=" + (Object)((Object)this.operator) + ")";
        }
    }
}

