/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.domain;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.NodeType;
import com.github.sidhant92.boolparser.domain.Node;

public class NumericRangeNode
extends Node {
    private final String field;
    private final Object fromValue;
    private final Object toValue;
    private final DataType fromDataType;
    private final DataType toDataType;

    @Override
    public NodeType getTokenType() {
        return NodeType.NUMERIC_RANGE;
    }

    public static NumericRangeNodeBuilder builder() {
        return new NumericRangeNodeBuilder();
    }

    public NumericRangeNode(String field, Object fromValue, Object toValue, DataType fromDataType, DataType toDataType) {
        this.field = field;
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.fromDataType = fromDataType;
        this.toDataType = toDataType;
    }

    public String getField() {
        return this.field;
    }

    public Object getFromValue() {
        return this.fromValue;
    }

    public Object getToValue() {
        return this.toValue;
    }

    public DataType getFromDataType() {
        return this.fromDataType;
    }

    public DataType getToDataType() {
        return this.toDataType;
    }

    public static class NumericRangeNodeBuilder {
        private String field;
        private Object fromValue;
        private Object toValue;
        private DataType fromDataType;
        private DataType toDataType;

        NumericRangeNodeBuilder() {
        }

        public NumericRangeNodeBuilder field(String field) {
            this.field = field;
            return this;
        }

        public NumericRangeNodeBuilder fromValue(Object fromValue) {
            this.fromValue = fromValue;
            return this;
        }

        public NumericRangeNodeBuilder toValue(Object toValue) {
            this.toValue = toValue;
            return this;
        }

        public NumericRangeNodeBuilder fromDataType(DataType fromDataType) {
            this.fromDataType = fromDataType;
            return this;
        }

        public NumericRangeNodeBuilder toDataType(DataType toDataType) {
            this.toDataType = toDataType;
            return this;
        }

        public NumericRangeNode build() {
            return new NumericRangeNode(this.field, this.fromValue, this.toValue, this.fromDataType, this.toDataType);
        }

        public String toString() {
            return "NumericRangeNode.NumericRangeNodeBuilder(field=" + this.field + ", fromValue=" + this.fromValue + ", toValue=" + this.toValue + ", fromDataType=" + (Object)((Object)this.fromDataType) + ", toDataType=" + (Object)((Object)this.toDataType) + ")";
        }
    }
}

