/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.domain;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.NodeType;
import com.github.sidhant92.boolparser.domain.Node;

public class UnaryNode
extends Node {
    private final DataType dataType;
    private final Object value;

    @Override
    public NodeType getTokenType() {
        return NodeType.UNARY;
    }

    public static UnaryNodeBuilder builder() {
        return new UnaryNodeBuilder();
    }

    public UnaryNode(DataType dataType, Object value) {
        this.dataType = dataType;
        this.value = value;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public Object getValue() {
        return this.value;
    }

    public static class UnaryNodeBuilder {
        private DataType dataType;
        private Object value;

        UnaryNodeBuilder() {
        }

        public UnaryNodeBuilder dataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public UnaryNodeBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public UnaryNode build() {
            return new UnaryNode(this.dataType, this.value);
        }

        public String toString() {
            return "UnaryNode.UnaryNodeBuilder(dataType=" + (Object)((Object)this.dataType) + ", value=" + this.value + ")";
        }
    }
}

