/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.util;

import com.github.sidhant92.boolparser.constant.DataType;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueUtils {
    private static final Logger log = LoggerFactory.getLogger(ValueUtils.class);

    public static Optional<Object> getValueFromMap(String key, Map<String, Object> data) {
        String[] keys = key.split("\\.");
        int size = keys.length;
        Optional<Object> fieldData = Optional.ofNullable(data.get(keys[0]));
        if (size == 1) {
            return fieldData;
        }
        if (fieldData.isPresent() && fieldData.get() instanceof Map) {
            try {
                return ValueUtils.getValueFromMap(keys[1], (Map)fieldData.get());
            }
            catch (ClassCastException ex) {
                return Optional.empty();
            }
        }
        log.error("could not find key {} for the data {}", (Object)key, data);
        return Optional.empty();
    }

    public static Object convertValue(String value, DataType dataType) {
        switch (dataType) {
            case INTEGER: {
                return Integer.parseInt(value);
            }
            case LONG: {
                return Long.parseLong(value);
            }
            case DECIMAL: {
                return Double.parseDouble(value);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case VERSION: {
                new ComparableVersion(value);
            }
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static DataType getNumericDataType(String value) {
        Optional<Integer> integerOptional = ValueUtils.parseInteger(value);
        return integerOptional.isPresent() ? DataType.INTEGER : DataType.LONG;
    }

    public static Optional<Integer> parseInteger(String number) {
        try {
            return Optional.of(Integer.parseInt(number));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }
}

