/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.application;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.domain.EvaluatedNode;
import com.github.sidhant92.boolparser.domain.FieldNode;
import com.github.sidhant92.boolparser.domain.arithmetic.ArithmeticFunctionNode;
import com.github.sidhant92.boolparser.domain.arithmetic.ArithmeticNode;
import com.github.sidhant92.boolparser.domain.arithmetic.UnaryNode;
import com.github.sidhant92.boolparser.domain.logical.Node;
import com.github.sidhant92.boolparser.exception.DataNotFoundException;
import com.github.sidhant92.boolparser.exception.UnsupportedToken;
import com.github.sidhant92.boolparser.function.FunctionEvaluatorService;
import com.github.sidhant92.boolparser.operator.OperatorService;
import com.github.sidhant92.boolparser.parser.BoolExpressionParser;
import com.github.sidhant92.boolparser.util.ValueUtils;
import io.vavr.control.Try;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ArithmeticExpressionEvaluator {
    private final BoolExpressionParser boolExpressionParser;
    private final OperatorService operatorService;
    private final FunctionEvaluatorService functionEvaluatorService;

    public ArithmeticExpressionEvaluator(BoolExpressionParser boolExpressionParser) {
        this.boolExpressionParser = boolExpressionParser;
        this.operatorService = new OperatorService();
        this.functionEvaluatorService = new FunctionEvaluatorService();
    }

    public Try<Object> evaluate(String expression, Map<String, Object> data) {
        Try<Node> tokenOptional = this.boolExpressionParser.parseExpression(expression, null);
        return tokenOptional.map(node -> this.evaluateToken((Node)node, data));
    }

    protected Object evaluate(Node node, Map<String, Object> data) {
        return this.evaluateToken(node, data);
    }

    private Object evaluateToken(Node node, Map<String, Object> data) {
        switch (node.getTokenType()) {
            case ARITHMETIC: {
                return this.evaluateArithmeticToken((ArithmeticNode)node, data);
            }
            case ARITHMETIC_FUNCTION: {
                return this.evaluateArithmeticFunctionToken((ArithmeticFunctionNode)node, data);
            }
            case UNARY: {
                return this.evaluateUnaryToken((UnaryNode)node, data);
            }
            case FIELD: {
                return this.evaluateFieldToken((FieldNode)node, data);
            }
        }
        throw new UnsupportedToken(node.getTokenType().name());
    }

    private Object evaluateFieldToken(FieldNode fieldNode, Map<String, Object> data) {
        Optional<Object> value = ValueUtils.getValueFromMap(fieldNode.getField(), data);
        if (!value.isPresent()) {
            throw new DataNotFoundException(fieldNode.getField());
        }
        return value.get();
    }

    private Object evaluateUnaryToken(UnaryNode unaryNode, Map<String, Object> data) {
        return unaryNode.getValue();
    }

    private Object evaluateArithmeticFunctionToken(ArithmeticFunctionNode arithmeticFunctionNode, Map<String, Object> data) {
        List<Object> resolvedValues = arithmeticFunctionNode.getItems().stream().map(item -> this.evaluate((Node)item, data)).collect(Collectors.toList());
        List<EvaluatedNode> flattenedValues = ValueUtils.mapToEvaluatedNodes(resolvedValues);
        return this.functionEvaluatorService.evaluateArithmeticFunction(arithmeticFunctionNode.getFunctionType(), flattenedValues);
    }

    private Object evaluateArithmeticToken(ArithmeticNode arithmeticNode, Map<String, Object> data) {
        Object leftValue = this.evaluateToken(arithmeticNode.getLeft(), data);
        if (arithmeticNode.getOperator().equals((Object)Operator.UNARY)) {
            if (leftValue instanceof EvaluatedNode) {
                EvaluatedNode left = (EvaluatedNode)leftValue;
                return this.operatorService.evaluateArithmeticOperator(left.getValue(), left.getDataType(), null, null, arithmeticNode.getOperator(), ContainerDataType.PRIMITIVE);
            }
            DataType leftDataType = ValueUtils.getDataType(leftValue);
            return this.operatorService.evaluateArithmeticOperator(leftValue, leftDataType, null, null, arithmeticNode.getOperator(), ContainerDataType.PRIMITIVE);
        }
        Object rightValue = this.evaluateToken(arithmeticNode.getRight(), data);
        if (leftValue instanceof EvaluatedNode && rightValue instanceof EvaluatedNode) {
            EvaluatedNode left = (EvaluatedNode)leftValue;
            EvaluatedNode right = (EvaluatedNode)rightValue;
            return this.operatorService.evaluateArithmeticOperator(left.getValue(), left.getDataType(), right.getValue(), right.getDataType(), arithmeticNode.getOperator(), ContainerDataType.PRIMITIVE);
        }
        if (leftValue instanceof EvaluatedNode) {
            EvaluatedNode left = (EvaluatedNode)leftValue;
            DataType rightDataType = ValueUtils.getDataType(rightValue);
            return this.operatorService.evaluateArithmeticOperator(left.getValue(), left.getDataType(), rightValue, rightDataType, arithmeticNode.getOperator(), ContainerDataType.PRIMITIVE);
        }
        if (rightValue instanceof EvaluatedNode) {
            EvaluatedNode right = (EvaluatedNode)rightValue;
            DataType leftDataType = ValueUtils.getDataType(leftValue);
            return this.operatorService.evaluateArithmeticOperator(leftValue, leftDataType, right.getValue(), right.getDataType(), arithmeticNode.getOperator(), ContainerDataType.PRIMITIVE);
        }
        DataType leftDataType = ValueUtils.getDataType(leftValue);
        DataType rightDataType = ValueUtils.getDataType(rightValue);
        return this.operatorService.evaluateArithmeticOperator(leftValue, leftDataType, rightValue, rightDataType, arithmeticNode.getOperator(), ContainerDataType.PRIMITIVE);
    }
}

