/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.datatype;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.datatype.AbstractDataType;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;

public class DateDataType
extends AbstractDataType<LocalDate> {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public DateDataType() {
        super(LocalDate.class);
    }

    @Override
    public DataType getDataType() {
        return DataType.DATE;
    }

    @Override
    public boolean isValid(Object value) {
        boolean isValid = super.defaultIsValid(value);
        if (!isValid) {
            return this.parseDate(value.toString()).isPresent();
        }
        return true;
    }

    @Override
    public boolean isValid(Object value, boolean useStrictValidation) {
        if (!useStrictValidation) {
            return this.isValid(value);
        }
        return super.defaultIsValid(value);
    }

    @Override
    public Optional<LocalDate> getValue(Object value) {
        Optional<LocalDate> result = this.defaultGetValue(value);
        if (result.isPresent()) {
            return result;
        }
        return this.parseDate(value.toString());
    }

    private Optional<LocalDate> parseDate(String dateString) {
        try {
            return Optional.of(LocalDate.parse(dateString, DATE_FORMATTER));
        }
        catch (DateTimeParseException ignored) {
            return Optional.empty();
        }
    }
}

