/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.datatype;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.datatype.AbstractDataType;
import java.math.BigDecimal;
import java.util.Optional;

public class DecimalDataType
extends AbstractDataType<BigDecimal> {
    public DecimalDataType() {
        super(BigDecimal.class);
    }

    @Override
    public DataType getDataType() {
        return DataType.DECIMAL;
    }

    @Override
    public boolean isValid(Object value) {
        boolean isValid = super.defaultIsValid(value);
        if (!isValid) {
            try {
                new BigDecimal(value.toString());
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValid(Object value, boolean useStrictValidation) {
        if (!useStrictValidation) {
            return this.isValid(value);
        }
        return super.defaultIsValid(value);
    }

    @Override
    public Optional<BigDecimal> getValue(Object value) {
        Optional<BigDecimal> result = this.defaultGetValue(value);
        if (result.isPresent()) {
            return result;
        }
        try {
            return Optional.of(new BigDecimal(value.toString()));
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

