/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.function;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.FunctionType;
import com.github.sidhant92.boolparser.domain.EvaluatedNode;
import com.github.sidhant92.boolparser.exception.InvalidContainerTypeException;
import com.github.sidhant92.boolparser.exception.InvalidDataType;
import com.github.sidhant92.boolparser.exception.InvalidExpressionException;
import com.github.sidhant92.boolparser.function.FunctionFactory;
import com.github.sidhant92.boolparser.function.arithmetic.AbstractFunction;
import java.util.List;

public class FunctionEvaluatorService {
    public FunctionEvaluatorService() {
        FunctionFactory.initialize();
    }

    public Object evaluateArithmeticFunction(FunctionType functionType, List<EvaluatedNode> items) {
        ContainerDataType containerDataType;
        AbstractFunction abstractFunction = FunctionFactory.getArithmeticFunction(functionType);
        if (items.isEmpty()) {
            throw new InvalidExpressionException("Empty items not allowed");
        }
        ContainerDataType containerDataType2 = containerDataType = items.size() > 1 ? ContainerDataType.LIST : ContainerDataType.PRIMITIVE;
        if (!abstractFunction.getAllowedContainerTypes().contains((Object)containerDataType)) {
            throw new InvalidContainerTypeException(String.format("Invalid container type %s for function %s", new Object[]{containerDataType, functionType.name()}));
        }
        boolean validDataType = items.stream().allMatch(item -> abstractFunction.getAllowedDataTypes().contains((Object)item.getDataType()));
        if (!validDataType) {
            throw new InvalidDataType(String.format("Invalid data type for function %s", functionType.name()));
        }
        items.forEach(item -> {
            if (!ContainerDataType.PRIMITIVE.isValid(item.getDataType(), item.getValue())) {
                throw new InvalidDataType(String.format("Validation failed for the function %s for the operand %s", functionType.name(), item.getValue()));
            }
        });
        return abstractFunction.evaluate(items);
    }
}

