/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.function.arithmetic;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.FunctionType;
import com.github.sidhant92.boolparser.datatype.DataTypeFactory;
import com.github.sidhant92.boolparser.datatype.DecimalDataType;
import com.github.sidhant92.boolparser.domain.EvaluatedNode;
import com.github.sidhant92.boolparser.function.arithmetic.AbstractFunction;
import com.github.sidhant92.boolparser.util.ValueUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class MedianFunction
extends AbstractFunction {
    @Override
    public Object evaluate(List<EvaluatedNode> items) {
        DecimalDataType decimalDataType = (DecimalDataType)DataTypeFactory.getDataType(DataType.DECIMAL);
        List itemsConverted = items.stream().map(item -> decimalDataType.getValue(item.getValue())).map(Optional::get).collect(Collectors.toList());
        Collections.sort(itemsConverted);
        if (items.size() % 2 == 0) {
            BigDecimal res = ((BigDecimal)itemsConverted.get(items.size() / 2)).add((BigDecimal)itemsConverted.get(items.size() / 2 - 1)).divide(new BigDecimal("2"), 2, 1);
            return ValueUtils.castDecimal(res);
        }
        return ValueUtils.castDecimal((BigDecimal)itemsConverted.get(items.size() / 2));
    }

    @Override
    public FunctionType getFunctionType() {
        return FunctionType.MEDIAN;
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.LIST);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.INTEGER, DataType.LONG, DataType.DECIMAL);
    }
}

