/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator.arithmetic;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.datatype.DataTypeFactory;
import com.github.sidhant92.boolparser.datatype.IntegerDataType;
import com.github.sidhant92.boolparser.datatype.LongDataType;
import com.github.sidhant92.boolparser.operator.arithmetic.AbstractOperator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ModulusOperator
extends AbstractOperator {
    @Override
    public Object evaluate(Object leftOperand, DataType leftOperandDataType, Object rightOperand, DataType rightOperandDataType) {
        if (leftOperandDataType.equals((Object)DataType.LONG) || rightOperandDataType.equals((Object)DataType.LONG)) {
            LongDataType longDataType = (LongDataType)DataTypeFactory.getDataType(DataType.LONG);
            return longDataType.getValue(leftOperand).get() % longDataType.getValue(rightOperand).get();
        }
        IntegerDataType integerDataType = (IntegerDataType)DataTypeFactory.getDataType(DataType.INTEGER);
        return integerDataType.getValue(leftOperand).get() % integerDataType.getValue(rightOperand).get();
    }

    @Override
    public Operator getOperator() {
        return Operator.MODULUS;
    }

    @Override
    public String getSymbol() {
        return "%";
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.PRIMITIVE);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.INTEGER, DataType.LONG);
    }
}

