/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.operator.comparison;

import com.github.sidhant92.boolparser.constant.ContainerDataType;
import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.constant.Operator;
import com.github.sidhant92.boolparser.operator.comparison.AbstractOperator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;

public class EqualsOperator
extends AbstractOperator {
    @Override
    public <T extends Comparable<? super T>> boolean evaluate(ContainerDataType containerDataType, Object leftOperand, DataType leftOperandDataType, List<Pair<Object, DataType>> rightOperands) {
        DataType comparisonType = this.getComparableDataType(leftOperandDataType, (DataType)((Object)rightOperands.get(0).getRight()));
        Optional<Comparable> leftValueOptional = containerDataType.getValue(comparisonType, leftOperand);
        Optional rightValueOptional = containerDataType.getValue(comparisonType, rightOperands.get(0).getLeft());
        return leftValueOptional.flatMap(leftValue -> rightValueOptional.map(leftValue::compareTo).map(a -> a == 0)).orElse(false);
    }

    private DataType getComparableDataType(DataType leftOperandDataType, DataType rightOperandDataType) {
        if (leftOperandDataType.priority > rightOperandDataType.priority) {
            return leftOperandDataType;
        }
        return rightOperandDataType;
    }

    @Override
    public Operator getOperator() {
        return Operator.EQUALS;
    }

    @Override
    public String getSymbol() {
        return "=";
    }

    @Override
    public List<ContainerDataType> getAllowedContainerTypes() {
        return Collections.singletonList(ContainerDataType.PRIMITIVE);
    }

    @Override
    public List<DataType> getAllowedDataTypes() {
        return Arrays.asList(DataType.values());
    }
}

