/*
 * Decompiled with CFR 0.152.
 */
package com.github.sidhant92.boolparser.util;

import com.github.sidhant92.boolparser.constant.DataType;
import com.github.sidhant92.boolparser.domain.EvaluatedNode;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class ValueUtils {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public static Optional<Object> getValueFromMap(String key, Map<String, Object> data) {
        String[] keys = key.split("\\.");
        int size = keys.length;
        Optional<Object> fieldData = Optional.ofNullable(data.get(keys[0]));
        if (size == 1) {
            return fieldData;
        }
        if (fieldData.isPresent() && fieldData.get() instanceof Map) {
            try {
                String newKey = Arrays.stream(keys).skip(1L).collect(Collectors.joining("."));
                return ValueUtils.getValueFromMap(newKey, (Map)fieldData.get());
            }
            catch (ClassCastException ex) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static List<EvaluatedNode> mapToEvaluatedNodes(List<Object> items) {
        ArrayList<EvaluatedNode> flattenedValues = new ArrayList<EvaluatedNode>();
        items.forEach(value -> {
            if (value instanceof EvaluatedNode) {
                EvaluatedNode node = (EvaluatedNode)value;
                if (node.getValue() instanceof Collection) {
                    ((Collection)node.getValue()).forEach(v -> flattenedValues.add(EvaluatedNode.builder().value(v).dataType(ValueUtils.getDataType(v)).build()));
                } else {
                    flattenedValues.add(node);
                }
            }
            if (value instanceof Collection) {
                ((Collection)value).forEach(v -> flattenedValues.add(EvaluatedNode.builder().value(v).dataType(ValueUtils.getDataType(v)).build()));
            } else {
                flattenedValues.add(EvaluatedNode.builder().value(value).dataType(ValueUtils.getDataType(value)).build());
            }
        });
        return flattenedValues;
    }

    public static Object convertValue(String value, DataType dataType) {
        switch (dataType) {
            case INTEGER: {
                return Integer.parseInt(value);
            }
            case LONG: {
                return Long.parseLong(value);
            }
            case DECIMAL: {
                return new BigDecimal(value);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case VERSION: {
                return new ComparableVersion(value);
            }
            case DATE: {
                return ValueUtils.parseDate(value).orElse(null);
            }
            case DATETIME: {
                return ValueUtils.parseDateTime(value).orElse(null);
            }
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            return value.substring(1, value.length() - 1);
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    public static Object castDecimal(double value) {
        if ((double)((int)value) == value) {
            return (int)value;
        }
        return new BigDecimal(value);
    }

    public static Object castLong(long value) {
        if ((long)((int)value) == value) {
            return (int)value;
        }
        return value;
    }

    public static Object castDecimal(BigDecimal value) {
        if (value.signum() == 0 || value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0) {
            return value.intValueExact();
        }
        return value;
    }

    public static DataType getNumericDataType(String value) {
        Optional<Integer> integerOptional = ValueUtils.parseInteger(value);
        return integerOptional.isPresent() ? DataType.INTEGER : DataType.LONG;
    }

    public static Optional<Integer> parseInteger(String number) {
        try {
            return Optional.of(Integer.parseInt(number));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static DataType getDataType(Object value) {
        if (value instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        if (value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            return DataType.DECIMAL;
        }
        if (value instanceof Integer) {
            return DataType.INTEGER;
        }
        if (value instanceof Long) {
            return DataType.LONG;
        }
        if (value instanceof ComparableVersion) {
            return DataType.VERSION;
        }
        if (value instanceof LocalDate) {
            return DataType.DATE;
        }
        if (value instanceof LocalDateTime) {
            return DataType.DATETIME;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (ValueUtils.parseDateTime(stringValue).isPresent()) {
                return DataType.DATETIME;
            }
            if (ValueUtils.parseDate(stringValue).isPresent()) {
                return DataType.DATE;
            }
        }
        return DataType.STRING;
    }

    private static Optional<LocalDate> parseDate(String dateString) {
        try {
            return Optional.of(LocalDate.parse(dateString, DATE_FORMATTER));
        }
        catch (DateTimeParseException ignored) {
            return Optional.empty();
        }
    }

    private static Optional<LocalDateTime> parseDateTime(String dateTimeString) {
        try {
            return Optional.of(LocalDateTime.parse(dateTimeString, DATETIME_FORMATTER));
        }
        catch (DateTimeParseException ignored) {
            return Optional.empty();
        }
    }
}

