/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.common.impl;

import com.github.sonus21.rqueue.common.RqueueLockManager;
import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import java.time.Duration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RqueueLockManagerImpl
implements RqueueLockManager {
    private final RqueueRedisTemplate<String> redisTemplate;

    public RqueueLockManagerImpl(RqueueRedisTemplate<String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public boolean acquireLock(String lockKey, Duration duration) {
        Assert.isTrue((!StringUtils.isEmpty((Object)lockKey) ? 1 : 0) != 0, (String)"key cannot be null.");
        Boolean result = this.redisTemplate.setIfAbsent(lockKey, lockKey, duration);
        return Boolean.TRUE.equals(result);
    }

    @Override
    public boolean releaseLock(String lockKey) {
        Assert.isTrue((!StringUtils.isEmpty((Object)lockKey) ? 1 : 0) != 0, (String)"key cannot be null.");
        Boolean result = this.redisTemplate.delete(lockKey);
        return Boolean.TRUE.equals(result);
    }
}

