/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.config;

import com.github.sonus21.rqueue.common.RqueueLockManager;
import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.common.impl.RqueueLockManagerImpl;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueSchedulerConfig;
import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.config.SimpleRqueueListenerContainerFactory;
import com.github.sonus21.rqueue.core.DelayedMessageScheduler;
import com.github.sonus21.rqueue.core.ProcessingMessageScheduler;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.RqueueMessageTemplateImpl;
import com.github.sonus21.rqueue.core.RqueueRedisListenerContainerFactory;
import com.github.sonus21.rqueue.utils.RedisUtils;
import com.github.sonus21.rqueue.web.view.DateTimeFunction;
import com.github.sonus21.rqueue.web.view.DeadLetterQueuesFunction;
import org.jtwig.environment.EnvironmentConfiguration;
import org.jtwig.environment.EnvironmentConfigurationBuilder;
import org.jtwig.spring.JtwigViewResolver;
import org.jtwig.web.servlet.JtwigRenderer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class RqueueListenerBaseConfig {
    public static final int MAX_DB_VERSION = 2;
    @Autowired(required=false)
    protected final SimpleRqueueListenerContainerFactory simpleRqueueListenerContainerFactory = new SimpleRqueueListenerContainerFactory();

    @Bean
    public RqueueConfig rqueueConfig(ConfigurableBeanFactory beanFactory, @Value(value="${rqueue.version.key:__rq::version}") String versionKey, @Value(value="${rqueue.db.version:}") Integer dbVersion) {
        int version;
        boolean sharedConnection = false;
        if (this.simpleRqueueListenerContainerFactory.getRedisConnectionFactory() == null) {
            sharedConnection = true;
            this.simpleRqueueListenerContainerFactory.setRedisConnectionFactory((RedisConnectionFactory)beanFactory.getBean(RedisConnectionFactory.class));
        }
        RedisConnectionFactory connectionFactory = this.simpleRqueueListenerContainerFactory.getRedisConnectionFactory();
        if (dbVersion == null) {
            version = RedisUtils.updateAndGetVersion(connectionFactory, versionKey, 2);
        } else if (dbVersion >= 1 && dbVersion <= 2) {
            RedisUtils.setVersion(connectionFactory, versionKey, dbVersion);
            version = dbVersion;
        } else {
            throw new IllegalStateException("Rqueue db version '" + dbVersion + "' is not correct");
        }
        return new RqueueConfig(connectionFactory, sharedConnection, version);
    }

    @Bean
    public RqueueWebConfig rqueueWebConfig() {
        return new RqueueWebConfig();
    }

    @Bean
    public RqueueSchedulerConfig rqueueSchedulerConfig() {
        return new RqueueSchedulerConfig();
    }

    protected RqueueMessageTemplate getMessageTemplate(RqueueConfig rqueueConfig) {
        if (this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate() != null) {
            return this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate();
        }
        this.simpleRqueueListenerContainerFactory.setRqueueMessageTemplate(new RqueueMessageTemplateImpl(rqueueConfig.getConnectionFactory()));
        return this.simpleRqueueListenerContainerFactory.getRqueueMessageTemplate();
    }

    @Bean
    public RedisTemplate<String, Long> rqueueRedisLongTemplate(RqueueConfig rqueueConfig) {
        return RedisUtils.getRedisTemplate(rqueueConfig.getConnectionFactory());
    }

    @Bean
    public RqueueRedisListenerContainerFactory rqueueRedisListenerContainerFactory() {
        return new RqueueRedisListenerContainerFactory();
    }

    @Bean
    public DelayedMessageScheduler delayedMessageScheduler() {
        return new DelayedMessageScheduler();
    }

    @Bean
    public ProcessingMessageScheduler processingMessageScheduler() {
        return new ProcessingMessageScheduler();
    }

    @Bean
    public RqueueRedisTemplate<String> stringRqueueRedisTemplate(RqueueConfig rqueueConfig) {
        return new RqueueRedisTemplate<String>(rqueueConfig.getConnectionFactory());
    }

    @Bean
    public RqueueLockManager rqueueLockManager(@Qualifier(value="stringRqueueRedisTemplate") RqueueRedisTemplate<String> rqueueRedisTemplate) {
        return new RqueueLockManagerImpl(rqueueRedisTemplate);
    }

    @Bean
    public JtwigViewResolver rqueueViewResolver() {
        EnvironmentConfiguration configuration = ((EnvironmentConfigurationBuilder)EnvironmentConfigurationBuilder.configuration().functions().add((Object)new DateTimeFunction()).add((Object)new DeadLetterQueuesFunction()).and()).build();
        JtwigRenderer renderer = new JtwigRenderer(configuration);
        JtwigViewResolver viewResolver = new JtwigViewResolver();
        viewResolver.setRenderer(renderer);
        viewResolver.setPrefix("classpath:/templates/rqueue/");
        viewResolver.setSuffix(".html");
        return viewResolver;
    }
}

