/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.sonus21.rqueue.utils.SerializationUtils;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.GenericMessage;

public class GenericMessageConverter
implements MessageConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericMessageConverter.class);
    private static ObjectMapper objectMapper = new ObjectMapper();

    public Object fromMessage(Message<?> message, Class<?> targetClass) {
        try {
            String payload = (String)message.getPayload();
            if (SerializationUtils.isJson(payload)) {
                Msg msg = (Msg)objectMapper.readValue(payload, Msg.class);
                Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(msg.getName());
                return objectMapper.readValue(msg.msg, c);
            }
        }
        catch (IOException | ClassCastException | ClassNotFoundException e) {
            log.warn("Exception", (Throwable)e);
        }
        return null;
    }

    public Message<?> toMessage(Object payload, MessageHeaders headers) {
        String name = payload.getClass().getName();
        try {
            String msg = objectMapper.writeValueAsString(payload);
            Msg message = new Msg(msg, name);
            return new GenericMessage((Object)objectMapper.writeValueAsString((Object)message));
        }
        catch (JsonProcessingException e) {
            log.error("Serialisation failed", (Throwable)e);
            return null;
        }
    }

    private static class Msg {
        private String msg;
        private String name;

        @Generated
        public String getMsg() {
            return this.msg;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setMsg(String msg) {
            this.msg = msg;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public Msg() {
        }

        @Generated
        public Msg(String msg, String name) {
            this.msg = msg;
            this.name = name;
        }
    }
}

