/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.exception.UnknownSwitchCase;
import lombok.Generated;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;

class RedisScriptFactory {
    RedisScriptFactory() {
    }

    static RedisScript getScript(ScriptType type) {
        ClassPathResource resource = new ClassPathResource(type.getPath());
        DefaultRedisScript script = new DefaultRedisScript();
        script.setLocation((Resource)resource);
        switch (type) {
            case ADD_MESSAGE: 
            case MOVE_MESSAGE: 
            case PUSH_MESSAGE: 
            case MOVE_MESSAGE_LIST_TO_LIST: 
            case MOVE_MESSAGE_LIST_TO_ZSET: 
            case MOVE_MESSAGE_ZSET_TO_ZSET: 
            case MOVE_MESSAGE_ZSET_TO_LIST: {
                script.setResultType(Long.class);
                return script;
            }
            case POP_MESSAGE: {
                script.setResultType(RqueueMessage.class);
                return script;
            }
        }
        throw new UnknownSwitchCase(type.toString());
    }

    @Generated
    public String toString() {
        return "RedisScriptFactory()";
    }

    static enum ScriptType {
        ADD_MESSAGE("scripts/add_message.lua"),
        POP_MESSAGE("scripts/pop_message.lua"),
        MOVE_MESSAGE("scripts/move_message.lua"),
        PUSH_MESSAGE("scripts/push_message.lua"),
        MOVE_MESSAGE_LIST_TO_LIST("scripts/move_message_list_to_list.lua"),
        MOVE_MESSAGE_LIST_TO_ZSET("scripts/move_message_list_to_zset.lua"),
        MOVE_MESSAGE_ZSET_TO_ZSET("scripts/move_message_zset_to_zset.lua"),
        MOVE_MESSAGE_ZSET_TO_LIST("scripts/move_message_zset_to_list.lua");

        private String path;

        private ScriptType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

