/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.core.RedisScriptFactory;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.models.MessageMoveResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.util.CollectionUtils;

public class RqueueMessageTemplateImpl
extends RqueueRedisTemplate<RqueueMessage>
implements RqueueMessageTemplate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueMessageTemplateImpl.class);
    private DefaultScriptExecutor<String> scriptExecutor;

    public RqueueMessageTemplateImpl(RedisConnectionFactory redisConnectionFactory) {
        super(redisConnectionFactory);
        this.scriptExecutor = new DefaultScriptExecutor(this.redisTemplate);
    }

    @Override
    public RqueueMessage pop(String queueName, String processingQueueName, String processingChannelName, long visibilityTimeout) {
        long currentTime = System.currentTimeMillis();
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.POP_MESSAGE);
        return (RqueueMessage)this.scriptExecutor.execute(script, Arrays.asList(queueName, processingQueueName, processingChannelName), new Object[]{currentTime, currentTime + visibilityTimeout});
    }

    @Override
    public Long addMessageWithDelay(String delayQueueName, String delayQueueChannelName, RqueueMessage rqueueMessage) {
        long queuedTime = rqueueMessage.getQueuedTime();
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.ADD_MESSAGE);
        return (Long)this.scriptExecutor.execute(script, Arrays.asList(delayQueueName, delayQueueChannelName), new Object[]{rqueueMessage, rqueueMessage.getProcessAt(), queuedTime});
    }

    @Override
    public Long addMessage(String listName, RqueueMessage rqueueMessage) {
        return this.rpush(listName, rqueueMessage);
    }

    @Override
    public Boolean addToZset(String zsetName, RqueueMessage rqueueMessage, long score) {
        return this.zadd(zsetName, rqueueMessage, score);
    }

    @Override
    public void moveMessage(String srcZsetName, String tgtZsetName, RqueueMessage src, RqueueMessage tgt, long delay) {
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.MOVE_MESSAGE);
        Long response = (Long)this.scriptExecutor.execute(script, Arrays.asList(srcZsetName, tgtZsetName), new Object[]{src, tgt, System.currentTimeMillis() + delay});
        if (response == null) {
            log.error("Duplicate processing for the message {}", (Object)src);
        }
    }

    @Override
    public List<RqueueMessage> getAllMessages(String queueName, String processingQueueName, String delayQueueName) {
        Set messagesFromZset;
        Set messagesInProcessingQueue;
        List<RqueueMessage> messages = this.lrange(queueName, 0L, -1L);
        if (CollectionUtils.isEmpty(messages)) {
            messages = new ArrayList();
        }
        if (!CollectionUtils.isEmpty(messagesInProcessingQueue = this.zrange(processingQueueName, 0L, -1L))) {
            messages.addAll(messagesInProcessingQueue);
        }
        if (delayQueueName != null && !CollectionUtils.isEmpty(messagesFromZset = this.zrange(delayQueueName, 0L, -1L))) {
            messages.addAll(messagesFromZset);
        }
        return messages;
    }

    private MessageMoveResult moveMessageToList(String src, String dst, int maxMessage, RedisScriptFactory.ScriptType scriptType) {
        RedisScript script = RedisScriptFactory.getScript(scriptType);
        long messagesInSrc = maxMessage;
        int remainingMessages = maxMessage;
        while (messagesInSrc > 0L && remainingMessages > 0) {
            long messageCount = Math.min(remainingMessages, 100);
            messagesInSrc = (Long)this.scriptExecutor.execute(script, Arrays.asList(src, dst), new Object[]{messageCount});
            remainingMessages = (int)((long)remainingMessages - messageCount);
        }
        return new MessageMoveResult(maxMessage - remainingMessages, true);
    }

    @Override
    public MessageMoveResult moveMessageListToList(String srcQueueName, String dstQueueName, int numberOfMessage) {
        return this.moveMessageToList(srcQueueName, dstQueueName, numberOfMessage, RedisScriptFactory.ScriptType.MOVE_MESSAGE_LIST_TO_LIST);
    }

    @Override
    public MessageMoveResult moveMessageZsetToList(String sourceZset, String destinationList, int maxMessage) {
        return this.moveMessageToList(sourceZset, destinationList, maxMessage, RedisScriptFactory.ScriptType.MOVE_MESSAGE_ZSET_TO_LIST);
    }

    @Override
    public MessageMoveResult moveMessageListToZset(String sourceList, String destinationZset, int maxMessage, long score) {
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.MOVE_MESSAGE_LIST_TO_ZSET);
        long messagesInList = maxMessage;
        int remainingMessages = maxMessage;
        while (messagesInList > 0L && remainingMessages > 0) {
            long messageCount = Math.min(remainingMessages, 100);
            messagesInList = (Long)this.scriptExecutor.execute(script, Arrays.asList(sourceList, destinationZset), new Object[]{messageCount, score});
            remainingMessages = (int)((long)remainingMessages - messageCount);
        }
        return new MessageMoveResult(maxMessage - remainingMessages, true);
    }

    @Override
    public MessageMoveResult moveMessageZsetToZset(String sourceZset, String destinationZset, int maxMessage, long newScore, boolean fixedScore) {
        RedisScript script = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.MOVE_MESSAGE_ZSET_TO_ZSET);
        long messageInZset = maxMessage;
        int remainingMessages = maxMessage;
        while (messageInZset > 0L && remainingMessages > 0) {
            long messageCount = Math.min(remainingMessages, 100);
            messageInZset = (Long)this.scriptExecutor.execute(script, Arrays.asList(sourceZset, destinationZset), new Object[]{messageCount, newScore, fixedScore});
            remainingMessages = (int)((long)remainingMessages - messageCount);
        }
        return new MessageMoveResult(maxMessage - remainingMessages, true);
    }

    @Override
    public List<RqueueMessage> readFromZset(String name, long start, long end) {
        Set messages = this.zrange(name, start, end);
        if (messages == null) {
            return new ArrayList<RqueueMessage>();
        }
        return new ArrayList<RqueueMessage>(messages);
    }

    @Override
    public List<ZSetOperations.TypedTuple<RqueueMessage>> readFromZsetWithScore(String name, long start, long end) {
        Set messages = this.zrangeWithScore(name, start, end);
        if (messages == null) {
            return new ArrayList<ZSetOperations.TypedTuple<RqueueMessage>>();
        }
        return new ArrayList<ZSetOperations.TypedTuple<RqueueMessage>>(messages);
    }

    @Override
    public List<RqueueMessage> readFromList(String name, long start, long end) {
        List<RqueueMessage> messages = this.lrange(name, start, end);
        if (messages == null) {
            return new ArrayList<RqueueMessage>();
        }
        return messages;
    }

    @Override
    public RedisTemplate<String, RqueueMessage> getTemplate() {
        return this.redisTemplate;
    }

    @Override
    public Long removeElementFromZset(String zsetName, RqueueMessage rqueueMessage) {
        return super.removeFromZset(zsetName, rqueueMessage);
    }
}

