/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.listener.PostProcessingHandler;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.listener.RqueueMessageListenerContainer;
import com.github.sonus21.rqueue.listener.RqueueMessagePoller;
import com.github.sonus21.rqueue.utils.ThreadUtils;
import com.github.sonus21.rqueue.utils.TimeoutUtils;
import java.util.Collections;
import org.slf4j.event.Level;

class DefaultRqueuePoller
extends RqueueMessagePoller {
    private final QueueDetail queueDetail;
    private final ThreadUtils.QueueThread queueThread;

    DefaultRqueuePoller(ThreadUtils.QueueThread queueThread, QueueDetail queueDetail, RqueueMessageListenerContainer container, PostProcessingHandler postProcessingHandler, int retryPerPoll) {
        super(queueDetail.getName(), container, postProcessingHandler, retryPerPoll);
        this.queueDetail = queueDetail;
        this.queueThread = queueThread;
        this.queues = Collections.singletonList(queueDetail.getName());
    }

    @Override
    long getSemaphoreWaiTime() {
        return this.getPollingInterval();
    }

    @Override
    void deactivate(int index, String queue, RqueueMessagePoller.DeactivateType deactivateType) {
        if (deactivateType == RqueueMessagePoller.DeactivateType.SEMAPHORE_UNAVAILABLE || deactivateType == RqueueMessagePoller.DeactivateType.NO_MESSAGE) {
            TimeoutUtils.sleepLog(this.getPollingInterval(), false);
        } else if (deactivateType == RqueueMessagePoller.DeactivateType.POLL_FAILED) {
            TimeoutUtils.sleepLog(this.getBackOffTime(), false);
        }
    }

    @Override
    void start() {
        this.log(Level.DEBUG, "Running Queue {}", null, this.queueDetail.getName());
        while (!this.shouldExit()) {
            this.poll(-1, this.queueDetail.getName(), this.queueDetail, this.queueThread);
        }
    }
}

