/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.listener;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.support.MessageProcessor;
import com.github.sonus21.rqueue.models.db.TaskStatus;
import com.github.sonus21.rqueue.utils.BaseLogger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MessageProcessorHandler
extends BaseLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageProcessorHandler.class);
    private final MessageProcessor manualDeletionMessageProcessor;
    private final MessageProcessor deadLetterQueueMessageProcessor;
    private final MessageProcessor discardMessageProcessor;
    private final MessageProcessor postExecutionMessageProcessor;

    public MessageProcessorHandler(MessageProcessor manualDeletionMessageProcessor, MessageProcessor deadLetterQueueMessageProcessor, MessageProcessor discardMessageProcessor, MessageProcessor postExecutionMessageProcessor) {
        super(log, null);
        this.manualDeletionMessageProcessor = manualDeletionMessageProcessor;
        this.deadLetterQueueMessageProcessor = deadLetterQueueMessageProcessor;
        this.discardMessageProcessor = discardMessageProcessor;
        this.postExecutionMessageProcessor = postExecutionMessageProcessor;
    }

    public void handleMessage(RqueueMessage rqueueMessage, Object userMessage, TaskStatus status) {
        MessageProcessor messageProcessor = null;
        switch (status) {
            case DELETED: {
                messageProcessor = this.manualDeletionMessageProcessor;
                break;
            }
            case MOVED_TO_DLQ: {
                messageProcessor = this.deadLetterQueueMessageProcessor;
                break;
            }
            case DISCARDED: {
                messageProcessor = this.discardMessageProcessor;
                break;
            }
            case SUCCESSFUL: {
                messageProcessor = this.postExecutionMessageProcessor;
                break;
            }
        }
        if (messageProcessor != null) {
            try {
                this.log(Level.DEBUG, "Calling {} processor for {}", null, new Object[]{status, rqueueMessage});
                messageProcessor.process(userMessage, rqueueMessage);
            }
            catch (Exception e) {
                this.log(Level.ERROR, "Message processor {} call failed", e, new Object[]{status});
            }
        }
    }
}

