/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.models.db;

import com.github.sonus21.rqueue.models.SerializableBase;
import com.github.sonus21.rqueue.utils.MessageUtils;
import lombok.Generated;

public class MessageMetadata
extends SerializableBase {
    private static final long serialVersionUID = 4200184682879443328L;
    private String id;
    private String messageId;
    private long totalExecutionTime;
    private boolean deleted;
    private Long deletedOn;

    public MessageMetadata(String id, String messageId) {
        this.id = id;
        this.messageId = messageId;
    }

    public MessageMetadata(String messageId) {
        this.id = MessageUtils.getMessageMetaId(messageId);
        this.messageId = messageId;
    }

    public void addExecutionTime(long jobStartTime) {
        this.totalExecutionTime += System.currentTimeMillis() - jobStartTime;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    @Generated
    public boolean isDeleted() {
        return this.deleted;
    }

    @Generated
    public Long getDeletedOn() {
        return this.deletedOn;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Generated
    public void setTotalExecutionTime(long totalExecutionTime) {
        this.totalExecutionTime = totalExecutionTime;
    }

    @Generated
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDeletedOn(Long deletedOn) {
        this.deletedOn = deletedOn;
    }

    @Generated
    public MessageMetadata(String id, String messageId, long totalExecutionTime, boolean deleted, Long deletedOn) {
        this.id = id;
        this.messageId = messageId;
        this.totalExecutionTime = totalExecutionTime;
        this.deleted = deleted;
        this.deletedOn = deletedOn;
    }

    @Generated
    public MessageMetadata() {
    }

    @Generated
    public String toString() {
        return "MessageMetadata(id=" + this.getId() + ", messageId=" + this.getMessageId() + ", totalExecutionTime=" + this.getTotalExecutionTime() + ", deleted=" + this.isDeleted() + ", deletedOn=" + this.getDeletedOn() + ")";
    }
}

