/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import com.github.sonus21.rqueue.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class BaseLogger {
    private final Logger log;
    private final String groupName;

    public BaseLogger(Logger log, String groupName) {
        this.log = log;
        this.groupName = groupName;
    }

    public void log(Level level, String msg, Throwable t, Object ... objects) {
        if (level == Level.DEBUG && !this.log.isDebugEnabled()) {
            return;
        }
        if (level == Level.ERROR && !this.log.isErrorEnabled()) {
            return;
        }
        if (level == Level.INFO && !this.log.isInfoEnabled()) {
            return;
        }
        if (level == Level.WARN && !this.log.isWarnEnabled()) {
            return;
        }
        if (StringUtils.isEmpty(this.groupName)) {
            this.logMessage(level, msg, objects);
        } else {
            int size = objects.length + 1 + (t == null ? 0 : 1);
            Object[] objects1 = new Object[size];
            System.arraycopy(objects, 0, objects1, 1, objects.length);
            objects1[0] = this.groupName;
            if (t != null) {
                objects1[objects1.length - 1] = t;
            }
            String txt = "[{}] " + msg;
            this.logMessage(level, txt, objects1);
        }
    }

    private void logMessage(Level level, String txt, Object[] objects) {
        switch (level) {
            case INFO: {
                this.log.info(txt, objects);
                break;
            }
            case WARN: {
                this.log.warn(txt, objects);
                break;
            }
            case DEBUG: {
                this.log.debug(txt, objects);
                break;
            }
            case ERROR: {
                this.log.error(txt, objects);
                break;
            }
            default: {
                this.log.trace(txt, objects);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public boolean isWarningEnabled() {
        return this.log.isWarnEnabled();
    }
}

