/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class DateTimeUtils {
    private static DateTimeFormatter simple = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm");

    DateTimeUtils() {
    }

    public static String milliToHumanRepresentation(long millis) {
        String prefix = "";
        if (millis < 0L) {
            prefix = "-";
        }
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        String s = days != 0L ? days + " Day, " + hours + " Hours, " + minutes + " Minutes, " + seconds + " Seconds." : (hours != 0L ? (hours %= 24L) + " Hours, " + minutes + " Minutes, " + seconds + " Seconds." : (minutes != 0L ? (minutes %= 60L) + " Minutes, " + seconds + " Seconds." : (seconds %= 60L) + " Seconds."));
        return prefix + s;
    }

    public static String formatMilliToString(Long milli) {
        if (milli == null) {
            return "";
        }
        Instant instant = Instant.ofEpochMilli(milli);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.of("UTC"));
        return zonedDateTime.format(simple);
    }

    public static LocalDate localDateFromMilli(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneOffset.UTC).toLocalDate();
    }

    public static LocalDate today() {
        return LocalDate.now(ZoneOffset.UTC);
    }
}

