/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.controller;

import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.models.db.TaskStatus;
import com.github.sonus21.rqueue.models.enums.AggregationType;
import com.github.sonus21.rqueue.models.enums.DataType;
import com.github.sonus21.rqueue.models.enums.NavTab;
import com.github.sonus21.rqueue.models.response.RedisDataDetail;
import com.github.sonus21.rqueue.utils.StringUtils;
import com.github.sonus21.rqueue.web.service.RqueueQDetailService;
import com.github.sonus21.rqueue.web.service.RqueueSystemManagerService;
import com.github.sonus21.rqueue.web.service.RqueueUtilityService;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jtwig.spring.JtwigViewResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.View;

@Controller
@RequestMapping(value={"rqueue"})
public class RqueueViewController {
    private final JtwigViewResolver rqueueViewResolver;
    private final RqueueConfig rqueueConfig;
    private final RqueueWebConfig rqueueWebConfig;
    private final RqueueQDetailService rqueueQDetailService;
    private final RqueueUtilityService rqueueUtilityService;
    private final RqueueSystemManagerService rqueueSystemManagerService;

    @Autowired
    public RqueueViewController(@Qualifier(value="rqueueViewResolver") JtwigViewResolver rqueueViewResolver, RqueueConfig rqueueConfig, RqueueWebConfig rqueueWebConfig, RqueueQDetailService rqueueQDetailService, RqueueUtilityService rqueueUtilityService, RqueueSystemManagerService rqueueSystemManagerService) {
        this.rqueueViewResolver = rqueueViewResolver;
        this.rqueueConfig = rqueueConfig;
        this.rqueueWebConfig = rqueueWebConfig;
        this.rqueueQDetailService = rqueueQDetailService;
        this.rqueueUtilityService = rqueueUtilityService;
        this.rqueueSystemManagerService = rqueueSystemManagerService;
    }

    private void addNavData(Model model, NavTab tab) {
        for (NavTab navTab : NavTab.values()) {
            String name = navTab.name().toLowerCase() + "Active";
            model.addAttribute(name, (Object)(tab == navTab ? 1 : 0));
        }
    }

    private void addBasicDetails(Model model, HttpServletRequest request) {
        Pair<String, String> releaseAndVersion = this.rqueueUtilityService.getLatestVersion();
        model.addAttribute("releaseLink", releaseAndVersion.getFirst());
        model.addAttribute("latestVersion", releaseAndVersion.getSecond());
        model.addAttribute("time", (Object)OffsetDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
        model.addAttribute("timeInMilli", (Object)System.currentTimeMillis());
        model.addAttribute("version", (Object)this.rqueueConfig.getVersion());
        String xForwardedPrefix = request.getHeader("x-forwarded-prefix");
        String prefix = "/";
        if (!StringUtils.isEmpty(xForwardedPrefix)) {
            if (xForwardedPrefix.endsWith("/")) {
                xForwardedPrefix = xForwardedPrefix.substring(0, xForwardedPrefix.length() - 1);
            }
            prefix = xForwardedPrefix + prefix;
        }
        model.addAttribute("urlPrefix", (Object)prefix);
    }

    @GetMapping
    public View index(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.addBasicDetails(model, request);
        this.addNavData(model, null);
        model.addAttribute("title", (Object)"Rqueue Dashboard");
        model.addAttribute("aggregatorTypes", Arrays.asList(AggregationType.values()));
        model.addAttribute("typeSelectors", TaskStatus.getActiveChartStatus());
        return this.rqueueViewResolver.resolveViewName("index", Locale.ENGLISH);
    }

    @GetMapping(value={"queues"})
    public View queues(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.addBasicDetails(model, request);
        this.addNavData(model, NavTab.QUEUES);
        model.addAttribute("title", (Object)"Queues");
        List<QueueConfig> queueConfigs = this.rqueueSystemManagerService.getSortedQueueConfigs();
        ArrayList<Map.Entry<String, List<Map.Entry<NavTab, RedisDataDetail>>>> queueNameConfigs = new ArrayList<Map.Entry<String, List<Map.Entry<NavTab, RedisDataDetail>>>>(this.rqueueQDetailService.getQueueDataStructureDetails(queueConfigs).entrySet());
        queueNameConfigs.sort(Comparator.comparing(Map.Entry::getKey));
        model.addAttribute("queues", queueConfigs);
        model.addAttribute("queueConfigs", queueNameConfigs);
        return this.rqueueViewResolver.resolveViewName("queues", Locale.ENGLISH);
    }

    @GetMapping(value={"queues/{queueName}"})
    public View queueDetail(@PathVariable String queueName, Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        QueueConfig queueConfig = this.rqueueSystemManagerService.getQueueConfig(queueName);
        List<NavTab> queueActions = this.rqueueQDetailService.getNavTabs(queueConfig);
        List<Map.Entry<NavTab, RedisDataDetail>> queueRedisDataDetail = this.rqueueQDetailService.getQueueDataStructureDetail(queueConfig);
        this.addBasicDetails(model, request);
        this.addNavData(model, NavTab.QUEUES);
        model.addAttribute("title", (Object)("Queue: " + queueName));
        model.addAttribute("queueName", (Object)queueName);
        model.addAttribute("aggregatorTypes", Arrays.asList(AggregationType.values()));
        model.addAttribute("typeSelectors", TaskStatus.getActiveChartStatus());
        model.addAttribute("queueActions", queueActions);
        model.addAttribute("queueRedisDataDetails", queueRedisDataDetail);
        model.addAttribute("config", (Object)queueConfig);
        return this.rqueueViewResolver.resolveViewName("queue_detail", Locale.ENGLISH);
    }

    @GetMapping(value={"running"})
    public View running(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.addBasicDetails(model, request);
        this.addNavData(model, NavTab.RUNNING);
        model.addAttribute("title", (Object)"Running Tasks");
        List<List<Object>> l = this.rqueueQDetailService.getRunningTasks();
        model.addAttribute("tasks", l.subList(1, l.size()));
        model.addAttribute("header", l.get(0));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"scheduled"})
    public View scheduled(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.addBasicDetails(model, request);
        this.addNavData(model, NavTab.SCHEDULED);
        model.addAttribute("title", (Object)"Scheduled Tasks");
        List<List<Object>> l = this.rqueueQDetailService.getScheduledTasks();
        model.addAttribute("tasks", l.subList(1, l.size()));
        model.addAttribute("header", l.get(0));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"dead"})
    public View dead(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.addBasicDetails(model, request);
        this.addNavData(model, NavTab.DEAD);
        model.addAttribute("title", (Object)"Tasks moved to dead letter queue");
        List<List<Object>> l = this.rqueueQDetailService.getDeadLetterTasks();
        model.addAttribute("tasks", l.subList(1, l.size()));
        model.addAttribute("header", l.get(0));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"pending"})
    public View pending(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.addBasicDetails(model, request);
        this.addNavData(model, NavTab.PENDING);
        model.addAttribute("title", (Object)"Tasks waiting for execution");
        List<List<Object>> l = this.rqueueQDetailService.getWaitingTasks();
        model.addAttribute("tasks", l.subList(1, l.size()));
        model.addAttribute("header", l.get(0));
        return this.rqueueViewResolver.resolveViewName("running", Locale.ENGLISH);
    }

    @GetMapping(value={"utility"})
    public View utility(Model model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!this.rqueueWebConfig.isEnable()) {
            response.setStatus(503);
            return null;
        }
        this.addBasicDetails(model, request);
        this.addNavData(model, NavTab.UTILITY);
        model.addAttribute("title", (Object)"Utility");
        model.addAttribute("supportedDataType", DataType.getEnabledDataTypes());
        return this.rqueueViewResolver.resolveViewName("utility", Locale.ENGLISH);
    }
}

