/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.dao.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.web.dao.RqueueSystemConfigDao;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class RqueueSystemConfigDaoImpl
implements RqueueSystemConfigDao {
    private final RqueueRedisTemplate<QueueConfig> rqueueRedisTemplate;
    private Map<String, QueueConfig> queueConfigMap = new ConcurrentHashMap<String, QueueConfig>();

    @Autowired
    public RqueueSystemConfigDaoImpl(RqueueConfig rqueueConfig) {
        this(new RqueueRedisTemplate<QueueConfig>(rqueueConfig.getConnectionFactory()));
    }

    public RqueueSystemConfigDaoImpl(RqueueRedisTemplate<QueueConfig> rqueueRedisTemplate) {
        this.rqueueRedisTemplate = rqueueRedisTemplate;
    }

    @Override
    public QueueConfig getQConfig(String key) {
        return this.getQConfig(key, false);
    }

    @Override
    public QueueConfig getQConfig(String key, boolean cache) {
        if (this.queueConfigMap.containsKey(key)) {
            return this.queueConfigMap.get(key);
        }
        QueueConfig queueConfig = this.rqueueRedisTemplate.get(key);
        if (queueConfig != null && cache) {
            this.queueConfigMap.put(key, queueConfig);
        }
        return queueConfig;
    }

    @Override
    public List<QueueConfig> findAllQConfig(Collection<String> ids) {
        return this.rqueueRedisTemplate.mget(ids).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void saveQConfig(QueueConfig queueConfig) {
        this.saveAllQConfig(Collections.singletonList(queueConfig));
    }

    @Override
    public void saveAllQConfig(List<QueueConfig> newConfigs) {
        if (!CollectionUtils.isEmpty(newConfigs)) {
            HashMap<String, QueueConfig> idToQueueConfig = new HashMap<String, QueueConfig>();
            for (QueueConfig queueConfig : newConfigs) {
                if (queueConfig == null) {
                    throw new IllegalArgumentException("queueConfig cannot be null");
                }
                if (queueConfig.getId() == null) {
                    throw new IllegalArgumentException("id cannot be null " + queueConfig);
                }
                idToQueueConfig.put(queueConfig.getId(), queueConfig);
            }
            this.rqueueRedisTemplate.mset(idToQueueConfig);
        }
    }
}

