/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.web.service.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.config.RqueueWebConfig;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.exception.UnknownSwitchCase;
import com.github.sonus21.rqueue.models.MessageMoveResult;
import com.github.sonus21.rqueue.models.db.QueueConfig;
import com.github.sonus21.rqueue.models.enums.DataType;
import com.github.sonus21.rqueue.models.request.MessageMoveRequest;
import com.github.sonus21.rqueue.models.response.BooleanResponse;
import com.github.sonus21.rqueue.models.response.MessageMoveResponse;
import com.github.sonus21.rqueue.models.response.StringResponse;
import com.github.sonus21.rqueue.utils.HttpUtils;
import com.github.sonus21.rqueue.utils.StringUtils;
import com.github.sonus21.rqueue.web.dao.RqueueSystemConfigDao;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import com.github.sonus21.rqueue.web.service.RqueueUtilityService;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Service;

@Service
public class RqueueUtilityServiceImpl
implements RqueueUtilityService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RqueueUtilityServiceImpl.class);
    private final RqueueWebConfig rqueueWebConfig;
    private final RqueueRedisTemplate<String> stringRqueueRedisTemplate;
    private final RqueueSystemConfigDao rqueueSystemConfigDao;
    private final RqueueMessageTemplate rqueueMessageTemplate;
    private final RqueueMessageMetadataService messageMetadataService;
    private final RqueueConfig rqueueConfig;
    private String latestVersion = "NA";
    private String releaseLink = "#";
    private long versionFetchTime = 0L;

    @Autowired
    public RqueueUtilityServiceImpl(RqueueConfig rqueueConfig, RqueueWebConfig rqueueWebConfig, @Qualifier(value="stringRqueueRedisTemplate") RqueueRedisTemplate<String> stringRqueueRedisTemplate, RqueueSystemConfigDao rqueueSystemConfigDao, RqueueMessageTemplate rqueueMessageTemplate, RqueueMessageMetadataService messageMetadataService) {
        this.stringRqueueRedisTemplate = stringRqueueRedisTemplate;
        this.rqueueSystemConfigDao = rqueueSystemConfigDao;
        this.rqueueWebConfig = rqueueWebConfig;
        this.rqueueConfig = rqueueConfig;
        this.rqueueMessageTemplate = rqueueMessageTemplate;
        this.messageMetadataService = messageMetadataService;
    }

    @Override
    public BooleanResponse deleteMessage(String queueName, String id) {
        String queueConfigKey = this.rqueueConfig.getQueueConfigKey(queueName);
        QueueConfig queueConfig = this.rqueueSystemConfigDao.getQConfig(queueConfigKey);
        BooleanResponse booleanResponse = new BooleanResponse();
        if (queueConfig == null) {
            booleanResponse.setCode(1);
            booleanResponse.setMessage("Queue config not found!");
            return booleanResponse;
        }
        this.messageMetadataService.deleteMessage(id, Duration.ofDays(30L));
        booleanResponse.setValue(true);
        return booleanResponse;
    }

    private MessageMoveResponse moveMessageToZset(MessageMoveRequest messageMoveRequest) {
        String src = messageMoveRequest.getSrc();
        String dst = messageMoveRequest.getDst();
        int requestMessageCount = messageMoveRequest.getMessageCount(this.rqueueWebConfig);
        String newScore = (String)((Object)messageMoveRequest.getOthers().get("newScore"));
        Boolean isFixedScore = (Boolean)messageMoveRequest.getOthers().get("fixedScore");
        long scoreInMilli = 0L;
        boolean fixedScore = false;
        if (newScore != null) {
            scoreInMilli = Long.parseLong(newScore);
        }
        if (isFixedScore != null) {
            fixedScore = isFixedScore;
        }
        MessageMoveResult result = messageMoveRequest.getSrcType() == DataType.ZSET ? this.rqueueMessageTemplate.moveMessageZsetToZset(src, dst, requestMessageCount, scoreInMilli, fixedScore) : this.rqueueMessageTemplate.moveMessageListToZset(src, dst, requestMessageCount, scoreInMilli);
        MessageMoveResponse response = new MessageMoveResponse(result.getNumberOfMessages());
        response.setValue(result.isSuccess());
        return response;
    }

    private MessageMoveResponse moveMessageToList(MessageMoveRequest messageMoveRequest) {
        String src = messageMoveRequest.getSrc();
        String dst = messageMoveRequest.getDst();
        int requestMessageCount = messageMoveRequest.getMessageCount(this.rqueueWebConfig);
        MessageMoveResult result = messageMoveRequest.getSrcType() == DataType.ZSET ? this.rqueueMessageTemplate.moveMessageZsetToList(src, dst, requestMessageCount) : this.rqueueMessageTemplate.moveMessageListToList(src, dst, requestMessageCount);
        MessageMoveResponse response = new MessageMoveResponse(result.getNumberOfMessages());
        response.setValue(result.isSuccess());
        return response;
    }

    @Override
    public MessageMoveResponse moveMessage(MessageMoveRequest messageMoveRequest) {
        String message = messageMoveRequest.validationMessage();
        if (!StringUtils.isEmpty(message)) {
            MessageMoveResponse transferResponse = new MessageMoveResponse();
            transferResponse.setCode(1);
            transferResponse.setMessage(message);
            return transferResponse;
        }
        DataType dstType = messageMoveRequest.getDstType();
        switch (dstType) {
            case ZSET: {
                return this.moveMessageToZset(messageMoveRequest);
            }
            case LIST: {
                return this.moveMessageToList(messageMoveRequest);
            }
        }
        throw new UnknownSwitchCase(dstType.name());
    }

    @Override
    public BooleanResponse deleteQueueMessages(String queueName, int remainingMessages) {
        int start = -1 * remainingMessages;
        int end = -1;
        if (remainingMessages == 0) {
            start = 2;
            end = 1;
        }
        if (this.stringRqueueRedisTemplate.type(queueName) == org.springframework.data.redis.connection.DataType.LIST) {
            this.stringRqueueRedisTemplate.ltrim(queueName, start, end);
            return new BooleanResponse(true);
        }
        return new BooleanResponse(false);
    }

    @Override
    public Pair<String, String> getLatestVersion() {
        String tagName;
        Map response;
        if (System.currentTimeMillis() - this.versionFetchTime > 86400000L && (response = (Map)HttpUtils.readUrl("https://api.github.com/repos/sonus21/rqueue/releases/latest", LinkedHashMap.class)) != null && (tagName = (String)response.get("tag_name")) != null && !tagName.isEmpty() && Character.toLowerCase(tagName.charAt(0)) == 'v') {
            this.releaseLink = (String)response.get("html_url");
            this.latestVersion = tagName.substring(1);
            this.versionFetchTime = System.currentTimeMillis();
        }
        return Pair.of((Object)this.releaseLink, (Object)this.latestVersion);
    }

    @Override
    public StringResponse getDataType(String name) {
        return new StringResponse(DataType.convertDataType(this.stringRqueueRedisTemplate.type(name)).name());
    }
}

