/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.config;

import com.github.sonus21.rqueue.utils.StringUtils;
import java.net.Proxy;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
public class RqueueConfig {
    private final RedisConnectionFactory connectionFactory;
    private final boolean sharedConnection;
    private final int dbVersion;
    @Value(value="${rqueue.version:2.1.0}")
    private String version;
    @Value(value="${rqueue.version.enabled:true}")
    private boolean versionEnabled;
    @Value(value="${rqueue.key.prefix:__rq::}")
    private String prefix;
    @Value(value="${rqueue.cluster.mode:true}")
    private boolean clusterMode;
    @Value(value="${rqueue.simple.queue.prefix:}")
    private String simpleQueuePrefix;
    @Value(value="${rqueue.delayed.queue.prefix:}")
    private String delayedQueuePrefix;
    @Value(value="${rqueue.delayed.queue.channel.prefix:}")
    private String delayedQueueChannelPrefix;
    @Value(value="${rqueue.processing.queue.name.prefix:}")
    private String processingQueuePrefix;
    @Value(value="${rqueue.processing.queue.channel.prefix:}")
    private String processingQueueChannelPrefix;
    @Value(value="${rqueue.queues.key.suffix:queues}")
    private String queuesKeySuffix;
    @Value(value="${rqueue.lock.key.prefix:lock::}")
    private String lockKeyPrefix;
    @Value(value="${rqueue.queue.stat.key.prefix:q-stat::}")
    private String queueStatKeyPrefix;
    @Value(value="${rqueue.queue.config.key.prefix:q-config::}")
    private String queueConfigKeyPrefix;
    @Value(value="${rqueue.retry.per.poll:1}")
    private int retryPerPoll;
    @Value(value="${rqueue.add.default.queue.with.queue.level.priority:true}")
    private boolean addDefaultQueueWithQueueLevelPriority;
    @Value(value="${rqueue.default.queue.with.queue.level.priority:-1}")
    private int defaultQueueWithQueueLevelPriority;
    @Value(value="${rqueue.net.proxy.host:}")
    private String proxyHost;
    @Value(value="${rqueue.net.proxy.port:8000}")
    private Integer proxyPort;
    @Value(value="${rqueue.net.proxy.type:HTTP}")
    private Proxy.Type proxyType;
    @Value(value="${rqueue.message.durability:10080}")
    private long messageDurabilityInMinute;
    @Value(value="${rqueue.message.durability.in-terminal-state:1800}")
    private long messageDurabilityInTerminalStateInSecond;

    public String getQueuesKey() {
        return this.prefix + this.queuesKeySuffix;
    }

    private String getSimpleQueueSuffix() {
        if (!StringUtils.isEmpty(this.simpleQueuePrefix)) {
            return this.simpleQueuePrefix;
        }
        if (this.dbVersion == 2) {
            return "queue::";
        }
        return "queue-v2::";
    }

    private String getDelayedQueueSuffix() {
        if (!StringUtils.isEmpty(this.delayedQueuePrefix)) {
            return this.delayedQueuePrefix;
        }
        if (this.dbVersion == 2) {
            return "d-queue::";
        }
        return "d-queue-v2::";
    }

    private String getDelayedQueueChannelSuffix() {
        if (!StringUtils.isEmpty(this.delayedQueueChannelPrefix)) {
            return this.delayedQueueChannelPrefix;
        }
        if (this.dbVersion == 2) {
            return "d-channel::";
        }
        return "d-channel-v2::";
    }

    private String getProcessingQueueSuffix() {
        if (!StringUtils.isEmpty(this.processingQueuePrefix)) {
            return this.processingQueuePrefix;
        }
        if (this.dbVersion == 2) {
            return "p-queue::";
        }
        return "p-queue-v2::";
    }

    private String getProcessingQueueChannelSuffix() {
        if (!StringUtils.isEmpty(this.processingQueueChannelPrefix)) {
            return this.processingQueueChannelPrefix;
        }
        if (this.dbVersion == 2) {
            return "p-channel::";
        }
        return "p-channel-v2::";
    }

    public String getQueueName(String queueName) {
        if (this.dbVersion == 1) {
            return queueName;
        }
        return this.prefix + this.getSimpleQueueSuffix() + this.getTaggedName(queueName);
    }

    public String getDelayedQueueName(String queueName) {
        if (this.dbVersion == 1) {
            return "rqueue-delay::" + queueName;
        }
        return this.prefix + this.getDelayedQueueSuffix() + this.getTaggedName(queueName);
    }

    public String getDelayedQueueChannelName(String queueName) {
        if (this.dbVersion == 1) {
            return "rqueue-channel::" + queueName;
        }
        return this.prefix + this.getDelayedQueueChannelSuffix() + this.getTaggedName(queueName);
    }

    public String getProcessingQueueName(String queueName) {
        if (this.dbVersion == 1) {
            return "rqueue-processing::" + queueName;
        }
        return this.prefix + this.getProcessingQueueSuffix() + this.getTaggedName(queueName);
    }

    public String getProcessingQueueChannelName(String queueName) {
        if (this.dbVersion == 1) {
            return "rqueue-processing-channel::" + queueName;
        }
        return this.prefix + this.getProcessingQueueChannelSuffix() + this.getTaggedName(queueName);
    }

    public String getLockKey(String key) {
        return this.prefix + this.lockKeyPrefix + key;
    }

    public String getQueueStatisticsKey(String name) {
        return this.prefix + this.queueStatKeyPrefix + name;
    }

    public String getQueueConfigKey(String name) {
        return this.prefix + this.queueConfigKeyPrefix + name;
    }

    private String getTaggedName(String queueName) {
        if (!this.clusterMode) {
            return queueName;
        }
        return "{" + queueName + "}";
    }

    @Generated
    public RedisConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Generated
    public boolean isSharedConnection() {
        return this.sharedConnection;
    }

    @Generated
    public int getDbVersion() {
        return this.dbVersion;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public boolean isVersionEnabled() {
        return this.versionEnabled;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public boolean isClusterMode() {
        return this.clusterMode;
    }

    @Generated
    public String getSimpleQueuePrefix() {
        return this.simpleQueuePrefix;
    }

    @Generated
    public String getDelayedQueuePrefix() {
        return this.delayedQueuePrefix;
    }

    @Generated
    public String getDelayedQueueChannelPrefix() {
        return this.delayedQueueChannelPrefix;
    }

    @Generated
    public String getProcessingQueuePrefix() {
        return this.processingQueuePrefix;
    }

    @Generated
    public String getProcessingQueueChannelPrefix() {
        return this.processingQueueChannelPrefix;
    }

    @Generated
    public String getQueuesKeySuffix() {
        return this.queuesKeySuffix;
    }

    @Generated
    public String getLockKeyPrefix() {
        return this.lockKeyPrefix;
    }

    @Generated
    public String getQueueStatKeyPrefix() {
        return this.queueStatKeyPrefix;
    }

    @Generated
    public String getQueueConfigKeyPrefix() {
        return this.queueConfigKeyPrefix;
    }

    @Generated
    public int getRetryPerPoll() {
        return this.retryPerPoll;
    }

    @Generated
    public boolean isAddDefaultQueueWithQueueLevelPriority() {
        return this.addDefaultQueueWithQueueLevelPriority;
    }

    @Generated
    public int getDefaultQueueWithQueueLevelPriority() {
        return this.defaultQueueWithQueueLevelPriority;
    }

    @Generated
    public String getProxyHost() {
        return this.proxyHost;
    }

    @Generated
    public Integer getProxyPort() {
        return this.proxyPort;
    }

    @Generated
    public Proxy.Type getProxyType() {
        return this.proxyType;
    }

    @Generated
    public long getMessageDurabilityInMinute() {
        return this.messageDurabilityInMinute;
    }

    @Generated
    public long getMessageDurabilityInTerminalStateInSecond() {
        return this.messageDurabilityInTerminalStateInSecond;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setVersionEnabled(boolean versionEnabled) {
        this.versionEnabled = versionEnabled;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public void setClusterMode(boolean clusterMode) {
        this.clusterMode = clusterMode;
    }

    @Generated
    public void setSimpleQueuePrefix(String simpleQueuePrefix) {
        this.simpleQueuePrefix = simpleQueuePrefix;
    }

    @Generated
    public void setDelayedQueuePrefix(String delayedQueuePrefix) {
        this.delayedQueuePrefix = delayedQueuePrefix;
    }

    @Generated
    public void setDelayedQueueChannelPrefix(String delayedQueueChannelPrefix) {
        this.delayedQueueChannelPrefix = delayedQueueChannelPrefix;
    }

    @Generated
    public void setProcessingQueuePrefix(String processingQueuePrefix) {
        this.processingQueuePrefix = processingQueuePrefix;
    }

    @Generated
    public void setProcessingQueueChannelPrefix(String processingQueueChannelPrefix) {
        this.processingQueueChannelPrefix = processingQueueChannelPrefix;
    }

    @Generated
    public void setQueuesKeySuffix(String queuesKeySuffix) {
        this.queuesKeySuffix = queuesKeySuffix;
    }

    @Generated
    public void setLockKeyPrefix(String lockKeyPrefix) {
        this.lockKeyPrefix = lockKeyPrefix;
    }

    @Generated
    public void setQueueStatKeyPrefix(String queueStatKeyPrefix) {
        this.queueStatKeyPrefix = queueStatKeyPrefix;
    }

    @Generated
    public void setQueueConfigKeyPrefix(String queueConfigKeyPrefix) {
        this.queueConfigKeyPrefix = queueConfigKeyPrefix;
    }

    @Generated
    public void setRetryPerPoll(int retryPerPoll) {
        this.retryPerPoll = retryPerPoll;
    }

    @Generated
    public void setAddDefaultQueueWithQueueLevelPriority(boolean addDefaultQueueWithQueueLevelPriority) {
        this.addDefaultQueueWithQueueLevelPriority = addDefaultQueueWithQueueLevelPriority;
    }

    @Generated
    public void setDefaultQueueWithQueueLevelPriority(int defaultQueueWithQueueLevelPriority) {
        this.defaultQueueWithQueueLevelPriority = defaultQueueWithQueueLevelPriority;
    }

    @Generated
    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Generated
    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Generated
    public void setProxyType(Proxy.Type proxyType) {
        this.proxyType = proxyType;
    }

    @Generated
    public void setMessageDurabilityInMinute(long messageDurabilityInMinute) {
        this.messageDurabilityInMinute = messageDurabilityInMinute;
    }

    @Generated
    public void setMessageDurabilityInTerminalStateInSecond(long messageDurabilityInTerminalStateInSecond) {
        this.messageDurabilityInTerminalStateInSecond = messageDurabilityInTerminalStateInSecond;
    }

    @Generated
    public RqueueConfig(RedisConnectionFactory connectionFactory, boolean sharedConnection, int dbVersion) {
        this.connectionFactory = connectionFactory;
        this.sharedConnection = sharedConnection;
        this.dbVersion = dbVersion;
    }
}

