/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.MessageScheduler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedMessageScheduler
extends MessageScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DelayedMessageScheduler.class);

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected long getNextScheduleTime(String queueName, Long value) {
        long currentTime = System.currentTimeMillis();
        if (value == null) {
            return currentTime + this.rqueueSchedulerConfig.getDelayedMessageTimeInterval();
        }
        if (value < currentTime) {
            return currentTime;
        }
        return currentTime + this.rqueueSchedulerConfig.getDelayedMessageTimeInterval();
    }

    @Override
    protected String getChannelName(String queueName) {
        return EndpointRegistry.get(queueName).getDelayedQueueChannelName();
    }

    @Override
    protected String getZsetName(String queueName) {
        return EndpointRegistry.get(queueName).getDelayedQueueName();
    }

    @Override
    protected String getThreadNamePrefix() {
        return "delayedMessageScheduler-";
    }

    @Override
    protected int getThreadPoolSize() {
        return this.rqueueSchedulerConfig.getDelayedMessageThreadPoolSize();
    }
}

