/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.exception.OverrideException;
import com.github.sonus21.rqueue.exception.QueueDoesNotExist;
import com.github.sonus21.rqueue.listener.QueueDetail;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class EndpointRegistry {
    private static final Object lock = new Object();
    private static final Map<String, QueueDetail> queueNameToDetail = new HashMap<String, QueueDetail>();

    private EndpointRegistry() {
    }

    public static QueueDetail get(String queueName) {
        QueueDetail queueDetail = queueNameToDetail.get(queueName);
        if (queueDetail == null) {
            throw new QueueDoesNotExist(queueName);
        }
        return queueDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(QueueDetail queueDetail) {
        Object object = lock;
        synchronized (object) {
            if (queueNameToDetail.containsKey(queueDetail.getName())) {
                throw new OverrideException(queueDetail.getName());
            }
            queueNameToDetail.put(queueDetail.getName(), queueDetail);
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete() {
        Object object = lock;
        synchronized (object) {
            queueNameToDetail.clear();
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getActiveQueues() {
        Object object = lock;
        synchronized (object) {
            List<String> queues = queueNameToDetail.values().stream().filter(QueueDetail::isActive).map(QueueDetail::getName).collect(Collectors.toList());
            lock.notifyAll();
            return queues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<QueueDetail> getActiveQueueDetails() {
        Object object = lock;
        synchronized (object) {
            List<QueueDetail> queueDetails = queueNameToDetail.values().stream().filter(QueueDetail::isActive).collect(Collectors.toList());
            lock.notifyAll();
            return queueDetails;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, QueueDetail> getActiveQueueMap() {
        Object object = lock;
        synchronized (object) {
            Map<String, QueueDetail> queueDetails = queueNameToDetail.values().stream().filter(QueueDetail::isActive).collect(Collectors.toMap(QueueDetail::getName, Function.identity()));
            lock.notifyAll();
            return queueDetails;
        }
    }

    public static int getActiveQueueCount() {
        return EndpointRegistry.getActiveQueues().size();
    }
}

