/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.config.RqueueSchedulerConfig;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.RedisScriptFactory;
import com.github.sonus21.rqueue.core.RqueueRedisListenerContainerFactory;
import com.github.sonus21.rqueue.core.ScheduledTaskDetail;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.event.RqueueBootstrapEvent;
import com.github.sonus21.rqueue.utils.ThreadUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import lombok.Generated;
import org.slf4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationListener;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.Topic;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class MessageScheduler
implements DisposableBean,
ApplicationListener<RqueueBootstrapEvent> {
    @Autowired
    protected RqueueSchedulerConfig rqueueSchedulerConfig;
    private RedisScript<Long> redisScript;
    private MessageSchedulerListener messageSchedulerListener;
    private DefaultScriptExecutor<String> defaultScriptExecutor;
    private Map<String, Boolean> queueRunningState;
    private Map<String, ScheduledTaskDetail> queueNameToScheduledTask;
    private Map<String, String> channelNameToQueueName;
    private Map<String, Long> queueNameToLastMessageSeenTime;
    private ThreadPoolTaskScheduler scheduler;
    @Autowired
    private RqueueRedisListenerContainerFactory rqueueRedisListenerContainerFactory;
    @Autowired
    @Qualifier(value="rqueueRedisLongTemplate")
    private RedisTemplate<String, Long> redisTemplate;

    protected abstract Logger getLogger();

    protected abstract long getNextScheduleTime(String var1, Long var2);

    protected abstract String getChannelName(String var1);

    protected abstract String getZsetName(String var1);

    protected abstract String getThreadNamePrefix();

    protected abstract int getThreadPoolSize();

    private void doStart() {
        for (String queueName : this.queueRunningState.keySet()) {
            this.startQueue(queueName);
        }
    }

    private void subscribeToRedisTopic(String queueName) {
        if (this.isRedisEnabled()) {
            String channelName = this.getChannelName(queueName);
            this.getLogger().debug("Queue {} subscribe to channel {}", (Object)queueName, (Object)channelName);
            this.rqueueRedisListenerContainerFactory.getContainer().addMessageListener((MessageListener)this.messageSchedulerListener, (Topic)new ChannelTopic(channelName));
            this.channelNameToQueueName.put(channelName, queueName);
        }
    }

    private void startQueue(String queueName) {
        if (Boolean.TRUE.equals(this.queueRunningState.get(queueName))) {
            return;
        }
        this.queueRunningState.put(queueName, true);
        if (this.scheduleTaskAtStartup() || !this.isRedisEnabled()) {
            long scheduleAt = System.currentTimeMillis() + 100L;
            this.schedule(queueName, scheduleAt, false);
        }
        this.subscribeToRedisTopic(queueName);
    }

    private void doStop() {
        if (CollectionUtils.isEmpty(this.queueRunningState)) {
            return;
        }
        for (Map.Entry<String, Boolean> runningStateByQueue : this.queueRunningState.entrySet()) {
            if (!Boolean.TRUE.equals(runningStateByQueue.getValue())) continue;
            this.stopQueue(runningStateByQueue.getKey());
        }
        this.waitForRunningQueuesToStop();
        this.queueNameToScheduledTask.clear();
    }

    private void waitForRunningQueuesToStop() {
        for (Map.Entry<String, Boolean> runningState : this.queueRunningState.entrySet()) {
            Future<?> future;
            boolean completedOrCancelled;
            String queueName = runningState.getKey();
            ScheduledTaskDetail scheduledTaskDetail = this.queueNameToScheduledTask.get(queueName);
            if (scheduledTaskDetail == null || (completedOrCancelled = (future = scheduledTaskDetail.getFuture()).isCancelled() || future.isDone())) continue;
            future.cancel(true);
        }
    }

    private void stopQueue(String queueName) {
        Assert.isTrue((boolean)this.queueRunningState.containsKey(queueName), (String)("Queue with name '" + queueName + "' does not exist"));
        this.queueRunningState.put(queueName, false);
    }

    private boolean scheduleTaskAtStartup() {
        return this.rqueueSchedulerConfig.isAutoStart();
    }

    private boolean isRedisEnabled() {
        return this.rqueueSchedulerConfig.isRedisEnabled();
    }

    public void destroy() throws Exception {
        this.doStop();
        if (this.scheduler != null) {
            this.scheduler.destroy();
        }
    }

    private void createScheduler(int queueCount) {
        if (queueCount == 0) {
            return;
        }
        this.scheduler = ThreadUtils.createTaskScheduler(Math.min(this.getThreadPoolSize(), queueCount), this.getThreadNamePrefix(), 60);
    }

    private boolean isQueueActive(String queueName) {
        Boolean val = this.queueRunningState.get(queueName);
        if (val == null) {
            return false;
        }
        return val;
    }

    private void addTask(MessageMoverTask timerTask, ScheduledTaskDetail scheduledTaskDetail) {
        this.getLogger().debug("Timer: {} Task {}", (Object)timerTask, (Object)scheduledTaskDetail);
        this.queueNameToScheduledTask.put(timerTask.getName(), scheduledTaskDetail);
    }

    protected synchronized void schedule(String queueName, Long startTime, boolean forceSchedule) {
        boolean completedOrCancelled;
        boolean isQueueActive = this.isQueueActive(queueName);
        if (!isQueueActive || this.scheduler == null) {
            return;
        }
        long lastSeenTime = this.queueNameToLastMessageSeenTime.getOrDefault(queueName, 0L);
        long currentTime = System.currentTimeMillis();
        if (!forceSchedule && currentTime - lastSeenTime < 100L) {
            return;
        }
        this.queueNameToLastMessageSeenTime.put(queueName, currentTime);
        ScheduledTaskDetail scheduledTaskDetail = this.queueNameToScheduledTask.get(queueName);
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        String zsetName = this.getZsetName(queueName);
        if (scheduledTaskDetail == null || forceSchedule) {
            Future future;
            long requiredDelay = Math.max(1L, startTime - currentTime);
            long taskStartTime = startTime;
            MessageMoverTask timerTask = new MessageMoverTask(queueDetail.getName(), queueDetail.getQueueName(), zsetName);
            if (requiredDelay < 100L) {
                future = this.scheduler.submit((Runnable)timerTask);
                taskStartTime = currentTime;
            } else {
                future = this.scheduler.schedule((Runnable)timerTask, Instant.ofEpochMilli(currentTime + requiredDelay));
            }
            this.addTask(timerTask, new ScheduledTaskDetail(taskStartTime, future));
            return;
        }
        long existingDelay = scheduledTaskDetail.getStartTime() - currentTime;
        Future<?> submittedTask = scheduledTaskDetail.getFuture();
        boolean bl = completedOrCancelled = submittedTask.isDone() || submittedTask.isCancelled();
        if (!completedOrCancelled && existingDelay < 100L && existingDelay > -30000L) {
            ThreadUtils.waitForTermination(this.getLogger(), submittedTask, 5000L, "LIST: {} ZSET: {}, Task: {} failed", queueDetail.getQueueName(), zsetName, scheduledTaskDetail);
        }
        MessageMoverTask timerTask = new MessageMoverTask(queueDetail.getName(), queueDetail.getQueueName(), zsetName);
        ScheduledFuture future = this.scheduler.schedule((Runnable)timerTask, Instant.ofEpochMilli(this.getNextScheduleTime(queueName, startTime)));
        this.addTask(timerTask, new ScheduledTaskDetail(startTime, future));
    }

    protected void initialize() {
        List<String> queueNames = EndpointRegistry.getActiveQueues();
        this.defaultScriptExecutor = new DefaultScriptExecutor(this.redisTemplate);
        this.redisScript = RedisScriptFactory.getScript(RedisScriptFactory.ScriptType.PUSH_MESSAGE);
        this.queueRunningState = new ConcurrentHashMap<String, Boolean>(queueNames.size());
        this.queueNameToScheduledTask = new ConcurrentHashMap<String, ScheduledTaskDetail>(queueNames.size());
        this.channelNameToQueueName = new ConcurrentHashMap<String, String>(queueNames.size());
        this.queueNameToLastMessageSeenTime = new ConcurrentHashMap<String, Long>(queueNames.size());
        this.createScheduler(queueNames.size());
        if (this.isRedisEnabled()) {
            this.messageSchedulerListener = new MessageSchedulerListener();
        }
        for (String queueName : queueNames) {
            this.queueRunningState.put(queueName, false);
        }
    }

    @Async
    public void onApplicationEvent(RqueueBootstrapEvent event) {
        this.doStop();
        if (event.isStart()) {
            if (EndpointRegistry.getActiveQueueCount() == 0) {
                this.getLogger().warn("No queues are configured");
                return;
            }
            this.initialize();
            this.doStart();
        }
    }

    private class MessageSchedulerListener
    implements MessageListener {
        private MessageSchedulerListener() {
        }

        public void onMessage(Message message, byte[] pattern) {
            if (message.getBody().length == 0 || message.getChannel().length == 0) {
                return;
            }
            String body = new String(message.getBody());
            String channel = new String(message.getChannel());
            MessageScheduler.this.getLogger().debug("Body: {} Channel: {}", (Object)body, (Object)channel);
            try {
                Long startTime = Long.parseLong(body);
                String queueName = (String)MessageScheduler.this.channelNameToQueueName.get(channel);
                if (queueName == null) {
                    MessageScheduler.this.getLogger().warn("Unknown channel name {}", (Object)channel);
                    return;
                }
                MessageScheduler.this.schedule(queueName, startTime, false);
            }
            catch (Exception e) {
                MessageScheduler.this.getLogger().error("Error occurred on a channel {}, body: {}", new Object[]{channel, body, e});
            }
        }
    }

    private class MessageMoverTask
    implements Runnable {
        private final String name;
        private final String queueName;
        private final String zsetName;

        MessageMoverTask(String name, String queueName, String zsetName) {
            this.name = name;
            this.queueName = queueName;
            this.zsetName = zsetName;
        }

        @Override
        public void run() {
            MessageScheduler.this.getLogger().debug("Running {}", (Object)this);
            try {
                if (MessageScheduler.this.isQueueActive(this.name)) {
                    long currentTime = System.currentTimeMillis();
                    Long value = (Long)MessageScheduler.this.defaultScriptExecutor.execute(MessageScheduler.this.redisScript, Arrays.asList(this.queueName, this.zsetName), new Object[]{currentTime, 100});
                    long nextExecutionTime = MessageScheduler.this.getNextScheduleTime(this.name, value);
                    MessageScheduler.this.schedule(this.name, nextExecutionTime, true);
                }
            }
            catch (RedisSystemException currentTime) {
            }
            catch (Exception e) {
                MessageScheduler.this.getLogger().warn("Task execution failed for the queue: {}", (Object)this.name, (Object)e);
            }
        }

        public String getName() {
            return this.name;
        }

        @Generated
        public String toString() {
            return "MessageScheduler.MessageMoverTask(name=" + this.getName() + ", queueName=" + this.queueName + ", zsetName=" + this.zsetName + ")";
        }
    }
}

