/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public interface RqueueMessageEnqueuer {
    public String enqueue(String var1, Object var2);

    public boolean enqueue(String var1, String var2, Object var3);

    public String enqueueWithRetry(String var1, Object var2, int var3);

    public boolean enqueueWithRetry(String var1, String var2, Object var3, int var4);

    public String enqueueWithPriority(String var1, String var2, Object var3);

    public boolean enqueueWithPriority(String var1, String var2, String var3, Object var4);

    default public boolean enqueueUnique(String queueName, String messageId, Object message) {
        return this.enqueue(queueName, messageId, message);
    }

    default public boolean enqueueUniqueWithPriority(String queueName, String priority, String messageId, Object message) {
        return this.enqueueWithPriority(queueName, priority, messageId, message);
    }

    public String enqueueIn(String var1, Object var2, long var3);

    public boolean enqueueIn(String var1, String var2, Object var3, long var4);

    default public String enqueueIn(String queueName, Object message, Duration delay) {
        return this.enqueueIn(queueName, message, delay.toMillis());
    }

    default public boolean enqueueIn(String queueName, String messageId, Object message, Duration delay) {
        return this.enqueueIn(queueName, messageId, message, delay.toMillis());
    }

    default public String enqueueIn(String queueName, Object message, long delay, TimeUnit unit) {
        return this.enqueueIn(queueName, message, unit.toMillis(delay));
    }

    default public boolean enqueueIn(String queueName, String messageId, Object message, long delay, TimeUnit unit) {
        return this.enqueueIn(queueName, messageId, message, unit.toMillis(delay));
    }

    public String enqueueInWithRetry(String var1, Object var2, int var3, long var4);

    public boolean enqueueInWithRetry(String var1, String var2, Object var3, int var4, long var5);

    public String enqueueInWithPriority(String var1, String var2, Object var3, long var4);

    public boolean enqueueInWithPriority(String var1, String var2, String var3, Object var4, long var5);

    default public String enqueueInWithPriority(String queueName, String priority, Object message, Duration delay) {
        return this.enqueueInWithPriority(queueName, priority, message, delay.toMillis());
    }

    default public boolean enqueueInWithPriority(String queueName, String priority, String messageId, Object message, Duration delay) {
        return this.enqueueInWithPriority(queueName, priority, messageId, message, delay.toMillis());
    }

    default public String enqueueInWithPriority(String queueName, String priority, Object message, long delay, TimeUnit unit) {
        return this.enqueueInWithPriority(queueName, priority, message, unit.toMillis(delay));
    }

    default public boolean enqueueInWithPriority(String queueName, String priority, String messageId, Object message, long delay, TimeUnit unit) {
        return this.enqueueInWithPriority(queueName, priority, messageId, message, unit.toMillis(delay));
    }

    default public boolean enqueueUniqueIn(String queueName, String messageId, Object message, long delayInMillisecond) {
        return this.enqueueIn(queueName, messageId, message, delayInMillisecond);
    }

    default public String enqueueAt(String queueName, Object message, long startTimeInMilliSeconds) {
        return this.enqueueIn(queueName, message, startTimeInMilliSeconds - System.currentTimeMillis());
    }

    default public boolean enqueueAt(String queueName, String messageId, Object message, long startTimeInMilliSeconds) {
        return this.enqueueIn(queueName, messageId, message, startTimeInMilliSeconds - System.currentTimeMillis());
    }

    default public String enqueueAt(String queueName, Object message, Instant starTime) {
        return this.enqueueAt(queueName, message, starTime.toEpochMilli());
    }

    default public boolean enqueueAt(String queueName, String messageId, Object message, Instant starTime) {
        return this.enqueueAt(queueName, messageId, message, starTime.toEpochMilli());
    }

    default public String enqueueAt(String queueName, Object message, Date starTime) {
        return this.enqueueAt(queueName, message, starTime.toInstant());
    }

    default public boolean enqueueAt(String queueName, String messageId, Object message, Date starTime) {
        return this.enqueueAt(queueName, messageId, message, starTime.toInstant());
    }

    default public String enqueueAtWithPriority(String queueName, String priority, Object message, long startTimeInMilliSecond) {
        return this.enqueueInWithPriority(queueName, priority, message, startTimeInMilliSecond - System.currentTimeMillis());
    }

    default public boolean enqueueAtWithPriority(String queueName, String priority, String messageId, Object message, long startTimeInMilliSecond) {
        return this.enqueueInWithPriority(queueName, priority, messageId, message, startTimeInMilliSecond - System.currentTimeMillis());
    }

    default public String enqueueAtWithPriority(String queueName, String priority, Object message, Instant startTime) {
        return this.enqueueAtWithPriority(queueName, priority, message, startTime.toEpochMilli());
    }

    default public boolean enqueueAtWithPriority(String queueName, String priority, String messageId, Object message, Instant instant) {
        return this.enqueueAtWithPriority(queueName, priority, messageId, message, instant.toEpochMilli());
    }

    default public String enqueueAtWithPriority(String queueName, String priority, Object message, Date time) {
        return this.enqueueAtWithPriority(queueName, priority, message, time.toInstant());
    }

    default public boolean enqueueAtWithPriority(String queueName, String priority, String messageId, Object message, Date time) {
        return this.enqueueAtWithPriority(queueName, priority, messageId, message, time.toInstant());
    }

    default public boolean enqueueUniqueAt(String queueName, String messageId, Object message, long timeInMilliSeconds) {
        return this.enqueueUniqueIn(queueName, messageId, message, timeInMilliSeconds - System.currentTimeMillis());
    }
}

