/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core;

import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import java.util.List;
import org.springframework.messaging.converter.MessageConverter;

public interface RqueueMessageManager {
    public boolean deleteAllMessages(String var1);

    default public boolean deleteAllMessages(String queueName, String priority) {
        return this.deleteAllMessages(PriorityUtils.getQueueNameForPriority(queueName, priority));
    }

    public List<Object> getAllMessages(String var1);

    default public List<Object> getAllMessages(String queueName, String priority) {
        return this.getAllMessages(PriorityUtils.getQueueNameForPriority(queueName, priority));
    }

    public Object getMessage(String var1, String var2);

    default public Object getMessage(String queueName, String priority, String id) {
        return this.getMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), id);
    }

    public boolean exist(String var1, String var2);

    default public boolean exist(String queueName, String priority, String id) {
        return this.exist(PriorityUtils.getQueueNameForPriority(queueName, priority), id);
    }

    public RqueueMessage getRqueueMessage(String var1, String var2);

    default public RqueueMessage getRqueueMessage(String queueName, String priority, String id) {
        return this.getRqueueMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), id);
    }

    public boolean deleteMessage(String var1, String var2);

    default public boolean deleteMessage(String queueName, String priority, String id) {
        return this.deleteMessage(PriorityUtils.getQueueNameForPriority(queueName, priority), id);
    }

    public MessageConverter getMessageConverter();
}

