/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.common.RqueueRedisTemplate;
import com.github.sonus21.rqueue.config.RqueueConfig;
import com.github.sonus21.rqueue.converter.GenericMessageConverter;
import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.RqueueMessage;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.models.db.MessageMetadata;
import com.github.sonus21.rqueue.models.db.MessageStatus;
import com.github.sonus21.rqueue.utils.MessageUtils;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import com.github.sonus21.rqueue.utils.Validator;
import com.github.sonus21.rqueue.web.service.RqueueMessageMetadataService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.util.Assert;

abstract class BaseMessageSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseMessageSender.class);
    protected CompositeMessageConverter messageConverter;
    protected RqueueMessageTemplate messageTemplate;
    @Autowired
    protected RqueueRedisTemplate<String> stringRqueueRedisTemplate;
    @Autowired
    protected RqueueConfig rqueueConfig;
    @Autowired
    protected RqueueMessageMetadataService rqueueMessageMetadataService;

    BaseMessageSender(RqueueMessageTemplate messageTemplate) {
        Assert.notNull((Object)messageTemplate, (String)"messageTemplate cannot be null");
        this.messageTemplate = messageTemplate;
    }

    protected void init(List<MessageConverter> messageConverters, boolean addDefault) {
        this.messageConverter = new CompositeMessageConverter(this.getMessageConverters(addDefault, messageConverters));
    }

    private void storeMessageMetadata(RqueueMessage rqueueMessage, Long delayInMillis) {
        Duration duration;
        MessageMetadata messageMetadata = new MessageMetadata(rqueueMessage, MessageStatus.ENQUEUED);
        if (delayInMillis != null) {
            duration = Duration.ofMillis(2L * delayInMillis);
            long minutes = duration.toMinutes();
            if (minutes < this.rqueueConfig.getMessageDurabilityInMinute()) {
                duration = Duration.ofMinutes(this.rqueueConfig.getMessageDurabilityInMinute());
            }
        } else {
            duration = Duration.ofMinutes(this.rqueueConfig.getMessageDurabilityInMinute());
        }
        this.rqueueMessageMetadataService.save(messageMetadata, duration);
    }

    private RqueueMessage constructMessage(String queueName, String messageId, Object message, Integer retryCount, Long delayInMilliSecs) {
        RqueueMessage rqueueMessage = MessageUtils.buildMessage((MessageConverter)this.messageConverter, queueName, message, retryCount, delayInMilliSecs);
        if (messageId != null) {
            rqueueMessage.setId(messageId);
        }
        return rqueueMessage;
    }

    private void enqueue(QueueDetail queueDetail, RqueueMessage rqueueMessage, Long delayInMilliSecs) {
        if (delayInMilliSecs == null || delayInMilliSecs <= 100L) {
            this.messageTemplate.addMessage(queueDetail.getQueueName(), rqueueMessage);
        } else {
            this.messageTemplate.addMessageWithDelay(queueDetail.getDelayedQueueName(), queueDetail.getDelayedQueueChannelName(), rqueueMessage);
        }
    }

    protected String pushMessage(String queueName, String messageId, Object message, Integer retryCount, Long delayInMilliSecs) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        RqueueMessage rqueueMessage = this.constructMessage(queueName, messageId, message, retryCount, delayInMilliSecs);
        try {
            this.enqueue(queueDetail, rqueueMessage, delayInMilliSecs);
            this.storeMessageMetadata(rqueueMessage, delayInMilliSecs);
        }
        catch (Exception e) {
            log.error("Queue: {} Message {} could not be pushed {}", new Object[]{queueName, rqueueMessage, e});
            return null;
        }
        return rqueueMessage.getId();
    }

    protected List<MessageConverter> getMessageConverters(boolean addDefault, List<MessageConverter> messageConverters) {
        ArrayList<MessageConverter> messageConverterList = new ArrayList<MessageConverter>();
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        messageConverterList.add((MessageConverter)stringMessageConverter);
        if (addDefault) {
            messageConverterList.add(new GenericMessageConverter());
        }
        messageConverterList.addAll(messageConverters);
        return messageConverterList;
    }

    protected void registerQueueInternal(String queueName, String ... priorities) {
        Validator.validateQueue(queueName);
        Assert.notNull((Object)priorities, (String)"priorities cannot be null");
        QueueDetail queueDetail = QueueDetail.builder().name(queueName).active(false).queueName(this.rqueueConfig.getQueueName(queueName)).delayedQueueName(this.rqueueConfig.getDelayedQueueName(queueName)).delayedQueueChannelName(this.rqueueConfig.getDelayedQueueChannelName(queueName)).processingQueueName(this.rqueueConfig.getProcessingQueueName(queueName)).processingQueueChannelName(this.rqueueConfig.getProcessingQueueChannelName(queueName)).build();
        EndpointRegistry.register(queueDetail);
        for (String priority : priorities) {
            String suffix = PriorityUtils.getSuffix(priority);
            queueDetail = QueueDetail.builder().name(queueName + suffix).active(false).queueName(this.rqueueConfig.getQueueName(queueName) + suffix).delayedQueueName(this.rqueueConfig.getDelayedQueueName(queueName) + suffix).delayedQueueChannelName(this.rqueueConfig.getDelayedQueueChannelName(queueName) + suffix).processingQueueName(this.rqueueConfig.getProcessingQueueName(queueName) + suffix).processingQueueChannelName(this.rqueueConfig.getProcessingQueueChannelName(queueName) + suffix).build();
            EndpointRegistry.register(queueDetail);
        }
    }
}

