/*
 * Decompiled with CFR 0.152.
 */
package com.github.sonus21.rqueue.core.impl;

import com.github.sonus21.rqueue.core.EndpointRegistry;
import com.github.sonus21.rqueue.core.RqueueEndpointManager;
import com.github.sonus21.rqueue.core.RqueueMessageTemplate;
import com.github.sonus21.rqueue.core.impl.BaseMessageSender;
import com.github.sonus21.rqueue.exception.QueueDoesNotExist;
import com.github.sonus21.rqueue.listener.QueueDetail;
import com.github.sonus21.rqueue.utils.PriorityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class RqueueEndpointManagerImpl
extends BaseMessageSender
implements RqueueEndpointManager {
    public RqueueEndpointManagerImpl(RqueueMessageTemplate messageTemplate) {
        super(messageTemplate);
    }

    @Override
    public void registerQueue(String name, String ... priorities) {
        this.registerQueueInternal(name, priorities);
    }

    @Override
    public boolean isQueueRegistered(String queueName) {
        try {
            EndpointRegistry.get(queueName);
            return true;
        }
        catch (QueueDoesNotExist e) {
            return false;
        }
    }

    @Override
    public List<QueueDetail> getQueueConfig(String queueName) {
        QueueDetail queueDetail = EndpointRegistry.get(queueName);
        Map<String, Integer> priorityMap = queueDetail.getPriority();
        if (CollectionUtils.isEmpty(priorityMap)) {
            return Collections.singletonList(queueDetail);
        }
        HashMap<String, Integer> localPriorityMap = new HashMap<String, Integer>(priorityMap);
        localPriorityMap.remove("DEFAULT_PRIORITY");
        ArrayList<QueueDetail> queueDetails = new ArrayList<QueueDetail>();
        queueDetails.add(queueDetail);
        for (String priority : localPriorityMap.keySet()) {
            queueDetails.add(EndpointRegistry.get(PriorityUtils.getQueueNameForPriority(queueName, priority)));
        }
        return queueDetails;
    }
}

